﻿<?php
if (session_status() === PHP_SESSION_NONE) {
	session_start();
}

require_once __DIR__ . '/config/messages.php';
$messages = load_messages();
$logoutMessage = $messages['logout_success'];
$currentLocale = $_SESSION['lang'] ?? null;

$_SESSION = [];
if (ini_get('session.use_cookies')) {
	$params = session_get_cookie_params();
	setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
}
session_destroy();

session_start();
if ($currentLocale !== null) {
	$_SESSION['lang'] = $currentLocale;
}
$_SESSION['flash']['success'] = $logoutMessage;
header('Location: index.php');
exit;
