﻿<?php
	// Start session and prepare CSRF + flash helpers
	if (session_status() === PHP_SESSION_NONE) {
		session_start();
	}

	if (empty($_SESSION['csrf_token'])) {
		$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
	}

	function flash_pop(string $key): ?string {
		if (!isset($_SESSION['flash'][$key])) {
			return null;
		}
		$value = $_SESSION['flash'][$key];
		unset($_SESSION['flash'][$key]);
		return $value;
	}

	$flashError = flash_pop('error');
	$flashSuccess = flash_pop('success');
?>
<!DOCTYPE html>
<html lang="vi">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<title>Đăng nhập - Quản lý nhân sự</title>
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="/CursorAI/assets/css/style.css" />
	<meta name="theme-color" content="#0e252b" />
	<link rel="apple-touch-icon" sizes="180x180" href="/CursorAI/assets/img/icons/apple-touch-icon.png" />
	<link rel="icon" type="image/png" sizes="32x32" href="/CursorAI/assets/img/icons/favicon-32x32.png" />
	<link rel="icon" type="image/png" sizes="16x16" href="/CursorAI/assets/img/icons/favicon-16x16.png" />
	<link rel="manifest" href="/CursorAI/assets/img/icons/site.webmanifest" />
	<link rel="shortcut icon" href="/CursorAI/assets/img/icons/favicon.ico" />
</head>
<body>
	<div class="bg"></div>
	<main class="container">
		<section class="card">
			<div class="card-header header-center">
				<div class="hero-logo"><img src="/CursorAI/assets/img/logo.png" alt="Human Resource Management" /></div>
				<div class="brand-text text-center">
					<h1>Quản lý nhân sự</h1>
					<p>Đăng nhập để tiếp tục</p>
				</div>
			</div>

			<?php if ($flashError): ?>
				<div class="alert alert-error" role="alert"><?= htmlspecialchars($flashError, ENT_QUOTES, 'UTF-8') ?></div>
			<?php endif; ?>
			<?php if ($flashSuccess): ?>
				<div class="alert alert-success" role="alert"><?= htmlspecialchars($flashSuccess, ENT_QUOTES, 'UTF-8') ?></div>
			<?php endif; ?>

						<form class="form" method="post" action="/CursorAI/login.php" novalidate>
				<input type="hidden" name="csrf_token" value="<?= htmlspecialchars(<?php
	// Start session and prepare CSRF + flash helpers
	if (session_status() === PHP_SESSION_NONE) {
		session_start();
	}

	if (empty($_SESSION['csrf_token'])) {
		$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
	}

	function flash_pop(string $key): ?string {
		if (!isset($_SESSION['flash'][$key])) {
			return null;
		}
		$value = $_SESSION['flash'][$key];
		unset($_SESSION['flash'][$key]);
		return $value;
	}

	$flashError = flash_pop('error');
	$flashSuccess = flash_pop('success');
?>
<!DOCTYPE html>
<html lang="vi">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<title>Đăng nhập - Quản lý nhân sự</title>
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="/CursorAI/assets/css/style.css" />
	<meta name="theme-color" content="#0e252b" />
	<link rel="apple-touch-icon" sizes="180x180" href="/CursorAI/assets/img/icons/apple-touch-icon.png" />
	<link rel="icon" type="image/png" sizes="32x32" href="/CursorAI/assets/img/icons/favicon-32x32.png" />
	<link rel="icon" type="image/png" sizes="16x16" href="/CursorAI/assets/img/icons/favicon-16x16.png" />
	<link rel="manifest" href="/CursorAI/assets/img/icons/site.webmanifest" />
	<link rel="shortcut icon" href="/CursorAI/assets/img/icons/favicon.ico" />
</head>
<body>
	<div class="bg"></div>
	<main class="container">
		<section class="card">
			<div class="card-header header-center">
				<div class="hero-logo"><img src="/CursorAI/assets/img/logo.png" alt="Human Resource Management" /></div>
				<div class="brand-text text-center">
					<h1>Quản lý nhân sự</h1>
					<p>Đăng nhập để tiếp tục</p>
				</div>
			</div>

			<?php if ($flashError): ?>
				<div class="alert alert-error" role="alert"><?= htmlspecialchars($flashError, ENT_QUOTES, 'UTF-8') ?></div>
			<?php endif; ?>
			<?php if ($flashSuccess): ?>
				<div class="alert alert-success" role="alert"><?= htmlspecialchars($flashSuccess, ENT_QUOTES, 'UTF-8') ?></div>
			<?php endif; ?>

			<form class="form" method="post" action="/CursorAI/login.php" novalidate>
				<input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8') ?>" />
				<div class="field">
					<label for="employee_code">Mã nhân viên</label>
					<div class="input-wrap">
						<input id="employee_code" name="employee_code" type="text" autocomplete="username" placeholder="vd: NV001" required />
						<span class="icon icon-user" aria-hidden="true">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" aria-hidden="true">
				<path d="M15.75 6.75a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0Z" />
				<path d="M4.5 20.25a7.5 7.5 0 0 1 15 0" />
							</svg>
						</span>
					</div>
				</div>
				<div class="field">
					<label for="password">Mật khẩu</label>
					<div class="input-wrap">
						<input id="password" name="password" type="password" autocomplete="current-password" placeholder="••••••" required />
						<span class="icon icon-lock" aria-hidden="true">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" aria-hidden="true">
				<path d="M16.5 10.5V6.75a4.5 4.5 0 1 0-9 0V10.5" />
				<path d="M7.5 10.5h9a1.5 1.5 0 0 1 1.5 1.5v6a1.5 1.5 0 0 1-1.5 1.5h-9a1.5 1.5 0 0 1-1.5-1.5v-6a1.5 1.5 0 0 1 1.5-1.5Z" />
				<path d="M12 14.25v2.25" />
							</svg>
						</span>
						<button type="button" class="toggle-pass" aria-label="Hiện mật khẩu" title="Hiện mật khẩu" data-state="hidden">
							<span class="visually-hidden">Hiện mật khẩu</span>
							<svg class="icon-eye icon-eye-open" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" aria-hidden="true">
				<path d="M2.036 12.322a1.012 1.012 0 0 1 0-.644C3.423 7.51 7.272 4.5 12 4.5c4.728 0 8.577 3.01 9.964 7.178a1.012 1.012 0 0 1 0 .644C20.577 16.49 16.728 19.5 12 19.5c-4.728 0-8.577-3.01-9.964-7.178Z" />
				<path d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
							</svg>
							<svg class="icon-eye icon-eye-closed" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" aria-hidden="true">
				<path d="M2.036 12.322a1.012 1.012 0 0 1 0-.644C3.423 7.51 7.272 4.5 12 4.5c4.728 0 8.577 3.01 9.964 7.178a1.012 1.012 0 0 1 0 .644C20.577 16.49 16.728 19.5 12 19.5c-4.728 0-8.577-3.01-9.964-7.178Z" />
				<path d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
				<path d="M4 5l16 16" />
							</svg>
						</button>
					</div>
				</div>
				<div class="actions">
					<button class="btn btn-primary" type="submit">Đăng nhập</button>
					<a class="link" href="#" onclick="return false;">Quên mật khẩu?</a>
				</div>
				<p class="hint">Tài khoản demo: <strong>NV001</strong> / <strong>123456</strong></p>
			</form>
		</section>
	</main>

	<script src="/CursorAI/assets/js/app.js"></script>
</body>
</html>


