﻿<?php
if (!isset($messages) || !is_array($messages)) {
	require_once __DIR__ . '/config/messages.php';
	$messages = load_messages();
}
?>
<aside class="dashboard-sidebar">
	<div class="sidebar-brand">
		<div class="brand-logo">
			<img src="assets/img/logo.png" alt="<?= htmlspecialchars($messages['control_brand_title'], ENT_QUOTES, 'UTF-8') ?>" />
		</div>
		<div class="brand-meta">
			<h2><?= htmlspecialchars($messages['control_brand_title'], ENT_QUOTES, 'UTF-8') ?></h2>
			<p><?= htmlspecialchars($messages['control_brand_subtitle'], ENT_QUOTES, 'UTF-8') ?></p>
		</div>
	</div>
	<nav class="sidebar-nav">
		<h3 class="nav-heading"><?= htmlspecialchars($messages['control_nav_heading'], ENT_QUOTES, 'UTF-8') ?></h3>
		<ul>
			<li class="active">
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M3 10.5L12 4l9 6.5" /><path d="M5 11.75V20h5.75v-4.5h2.5V20H19v-8.25" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_home'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M12 4l7 3.8v5.4c0 4.4-3 7.3-7 9.1-4-1.8-7-4.7-7-9.1V7.8L12 4Z" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_admin'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M9.5 11a3 3 0 1 1 6 0 3 3 0 0 1-6 0Z" /><path d="M5 19c0-3 3-5 7-5s7 2 7 5" /><path d="M5.5 11.5a2.5 2.5 0 1 1 .1-5" /><path d="M4 14.5c.7-1.6 2.4-2.5 4.2-2.5" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_hr'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M7 4v3" /><path d="M17 4v3" /><rect x="4" y="7" width="16" height="13" rx="2" /><path d="M4 11h16" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_planner'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M6 18v-6" /><path d="M12 18V9" /><path d="M18 18v-9" /><path d="M4 20h16" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_reports'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M6.5 8.5 12 5l5.5 3.5-5.5 3.5-5.5-3.5Z" /><path d="M6.5 15.5 12 19l5.5-3.5" /><path d="M6.5 12 12 15l5.5-3" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_ui'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><rect x="4" y="6" width="16" height="12" rx="2" /><path d="M4 12h16" /><path d="M12 6v12" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_tables'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M12 4a8 8 0 1 0 8 8h-8V4Z" /><path d="M12 4a8 8 0 0 1 8 8" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_data'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><rect x="4" y="5" width="7" height="7" rx="1.5" /><rect x="13" y="5" width="7" height="4" rx="1.5" /><rect x="13" y="11" width="7" height="8" rx="1.5" /><rect x="4" y="13" width="7" height="6" rx="1.5" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_layouts'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
		</ul>
	</nav>
	<div class="sidebar-footer">
		<h3 class="nav-heading"><?= htmlspecialchars($messages['control_footer_heading'], ENT_QUOTES, 'UTF-8') ?></h3>
		<ul>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M7 3h8l4 4v14H7a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2Z" /><path d="M15 3v4h4" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_footer_pages'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M12 4.5 13.5 8 17 9.5 13.5 11 12 14.5 10.5 11 7 9.5 10.5 8Z" /><path d="M6 15.5 7 17l-1 1 1.5-.25L8 19l.5-1.75L10 17l-1-.75" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_footer_extras'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M5 6h14" /><path d="M5 12h9" /><path d="M5 18h6" /><circle cx="18" cy="12" r="1.5" /><circle cx="16" cy="18" r="1" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_footer_multilevel'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
		</ul>
		<div class="sidebar-meta">
			<p><?= htmlspecialchars($messages['control_footer_copyright'], ENT_QUOTES, 'UTF-8') ?></p>
		</div>
	</div>
</aside>
