﻿document.addEventListener('DOMContentLoaded', () => {
	const toggle = document.querySelector('.toggle-pass');
	const input = document.getElementById('password');
	const languageSelect = document.querySelector('#site-language');
	const languageIcon = document.querySelector('.language-flag img');
	const languageToggle = document.querySelector('.language-select__toggle');

	if (languageSelect) {
		const updateLanguageIcon = () => {
			if (!languageIcon) {
				return;
			}
			const selectedOption = languageSelect.options[languageSelect.selectedIndex];
			if (!selectedOption) {
				return;
			}
			const iconPath = selectedOption.getAttribute('data-icon');
			if (iconPath) {
				languageIcon.src = iconPath;
				languageIcon.alt = selectedOption.textContent.trim();
			}
		};

		updateLanguageIcon();
		languageSelect.addEventListener('change', updateLanguageIcon);

		if (languageToggle) {
			languageToggle.addEventListener('click', (event) => {
				event.preventDefault();
				event.stopPropagation();
				try {
					languageSelect.focus({ preventScroll: true });
				} catch (error) {
					languageSelect.focus();
				}

				if (typeof languageSelect.showPicker === 'function') {
					languageSelect.showPicker();
				} else {
					try {
						languageSelect.click();
					} catch (error) {
						const mouseEvent = new MouseEvent('mousedown', {
							bubbles: true,
							cancelable: true,
							view: window
						});
						languageSelect.dispatchEvent(mouseEvent);
					}
				}
			});
		}
	}

	if (toggle && input) {
		const showLabel = toggle.dataset.showLabel || 'Show password';
		const hideLabel = toggle.dataset.hideLabel || 'Hide password';

		const applyLabel = () => {
			const isVisible = input.getAttribute('type') === 'text';
			const label = isVisible ? hideLabel : showLabel;
			toggle.setAttribute('aria-label', label);
			toggle.setAttribute('title', label);
			const srText = toggle.querySelector('.visually-hidden');
			if (srText) {
				srText.textContent = label;
			}
		};

		toggle.addEventListener('click', () => {
			const isHidden = input.getAttribute('type') === 'password';
			input.setAttribute('type', isHidden ? 'text' : 'password');
			toggle.dataset.state = isHidden ? 'visible' : 'hidden';
			applyLabel();
		});

		applyLabel();
	}

	const fields = document.querySelectorAll('.field');
	fields.forEach((el, idx) => {
		el.animate([
			{ opacity: 0, transform: 'translateY(8px)' },
			{ opacity: 1, transform: 'translateY(0)' }
		], { duration: 350, delay: 80 * idx, easing: 'cubic-bezier(.2,.6,.2,1)', fill: 'both' });
	});
});
