﻿<?php
if (session_status() === PHP_SESSION_NONE) {
	session_start();
}
require_once __DIR__ . '/config/messages.php';
$currentLocale = determine_locale();
$messages = load_messages($currentLocale);

$languageOptions = [
    'vn' => [
        'label' => $messages['language_vietnamese'],
        'icon' => 'assets/img/icons/flags/vn.svg',
    ],
    'eng' => [
        'label' => $messages['language_english'],
        'icon' => 'assets/img/icons/flags/us.svg',
    ],
];

$currentLanguageOption = $languageOptions[$currentLocale] ?? $languageOptions['vn'];
$currentFlagIcon = $currentLanguageOption['icon'];
$currentFlagAlt = $currentLanguageOption['label'];

if (empty($_SESSION['csrf_token'])) {
	$_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

function flash_pop(string $key): ?string {
	if (!isset($_SESSION['flash'][$key])) {
		return null;
	}
	$value = $_SESSION['flash'][$key];
	unset($_SESSION['flash'][$key]);
	return $value;
}

$flashError = flash_pop('error');
$flashSuccess = flash_pop('success');
?>
<!DOCTYPE html>
<html lang="<?= $currentLocale === 'eng' ? 'en' : 'vi' ?>">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<title><?= htmlspecialchars($messages['page_title'], ENT_QUOTES, 'UTF-8') ?></title>
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/style.css" />
	<meta name="theme-color" content="#0e252b" />
	<link rel="apple-touch-icon" sizes="180x180" href="assets/img/icons/apple-touch-icon.png" />
	<link rel="icon" type="image/png" sizes="32x32" href="assets/img/icons/favicon-32x32.png" />
	<link rel="icon" type="image/png" sizes="16x16" href="assets/img/icons/favicon-16x16.png" />
	<link rel="manifest" href="assets/img/icons/site.webmanifest" />
	<link rel="shortcut icon" href="assets/img/icons/favicon.ico" />
</head>
<body>
	<div class="bg"></div>
	<main class="container">
		<section class="card">
			<div class="card-header header-center">
				<div class="hero-logo"><img src="assets/img/logo.png" alt="Luna Human Resource Management" /></div>
				<div class="brand-text text-center">
					<h1><?= htmlspecialchars($messages['brand_heading'], ENT_QUOTES, 'UTF-8') ?></h1>
					<p><?= htmlspecialchars($messages['brand_subheading'], ENT_QUOTES, 'UTF-8') ?></p>
				</div>
			</div>

			<?php if ($flashError): ?>
				<div class="alert alert-error" role="alert"><?= htmlspecialchars($flashError, ENT_QUOTES, 'UTF-8') ?></div>
			<?php endif; ?>
			<?php if ($flashSuccess): ?>
				<div class="alert alert-success" role="alert"><?= htmlspecialchars($flashSuccess, ENT_QUOTES, 'UTF-8') ?></div>
			<?php endif; ?>

			<form class="form" method="post" action="login.php" novalidate>
				<input type="hidden" name="csrf_token" value="<?= htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, 'UTF-8') ?>" />
				<div class="field">
					<label for="employee_code"><?= htmlspecialchars($messages['employee_code_label'], ENT_QUOTES, 'UTF-8') ?></label>
					<div class="input-wrap">
						<input id="employee_code" name="employee_code" type="text" autocomplete="username" placeholder="<?= htmlspecialchars($messages['employee_code_placeholder'], ENT_QUOTES, 'UTF-8') ?>" required />
						<span class="icon icon-user" aria-hidden="true">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" aria-hidden="true">
								<path d="M15.75 6.75a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0Z" />
								<path d="M4.5 20.25a7.5 7.5 0 0 1 15 0" />
							</svg>
						</span>
					</div>
				</div>
				<div class="field">
					<label for="password"><?= htmlspecialchars($messages['password_label'], ENT_QUOTES, 'UTF-8') ?></label>
					<div class="input-wrap">
						<input id="password" name="password" type="password" autocomplete="current-password" placeholder="<?= htmlspecialchars($messages['password_placeholder'], ENT_QUOTES, 'UTF-8') ?>" required />
						<span class="icon icon-lock" aria-hidden="true">
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" aria-hidden="true">
								<path d="M16.5 10.5V6.75a4.5 4.5 0 1 0-9 0V10.5" />
								<path d="M7.5 10.5h9a1.5 1.5 0 0 1 1.5 1.5v6a1.5 1.5 0 0 1-1.5 1.5h-9a1.5 1.5 0 0 1-1.5-1.5v-6a1.5 1.5 0 0 1 1.5-1.5Z" />
								<path d="M12 14.25v2.25" />
							</svg>
						</span>
						<button type="button" class="toggle-pass" aria-label="<?= htmlspecialchars($messages['toggle_password_show'], ENT_QUOTES, 'UTF-8') ?>" title="<?= htmlspecialchars($messages['toggle_password_show'], ENT_QUOTES, 'UTF-8') ?>" data-state="hidden" data-show-label="<?= htmlspecialchars($messages['toggle_password_show'], ENT_QUOTES, 'UTF-8') ?>" data-hide-label="<?= htmlspecialchars($messages['toggle_password_hide'], ENT_QUOTES, 'UTF-8') ?>">
							<span class="visually-hidden"><?= htmlspecialchars($messages['toggle_password_show'], ENT_QUOTES, 'UTF-8') ?></span>
							<svg class="icon-eye icon-eye-open" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" aria-hidden="true">
								<path d="M2.036 12.322a1.012 1.012 0 0 1 0-.644C3.423 7.51 7.272 4.5 12 4.5c4.728 0 8.577 3.01 9.964 7.178a1.012 1.012 0 0 1 0 .644C20.577 16.49 16.728 19.5 12 19.5c-4.728 0-8.577-3.01-9.964-7.178Z" />
								<path d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
							</svg>
							<svg class="icon-eye icon-eye-closed" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.6" aria-hidden="true">
								<path d="M2.036 12.322a1.012 1.012 0 0 1 0-.644C3.423 7.51 7.272 4.5 12 4.5c4.728 0 8.577 3.01 9.964 7.178a1.012 1.012 0 0 1 0 .644C20.577 16.49 16.728 19.5 12 19.5c-4.728 0-8.577-3.01-9.964-7.178Z" />
								<path d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
								<path d="M4 5l16 16" />
							</svg>
						</button>
					</div>
				</div>
				<div class="actions">
					<button class="btn btn-primary" type="submit"><?= htmlspecialchars($messages['login_button'], ENT_QUOTES, 'UTF-8') ?></button>
					<a class="link" href="#" onclick="return false;"><?= htmlspecialchars($messages['forgot_link'], ENT_QUOTES, 'UTF-8') ?></a>
				</div>
				<!--<p class="hint"><?= $messages['demo_hint'] ?></p>-->
			</form>
			<form method="get" class="language-switch" aria-label="<?= htmlspecialchars($messages['language_label'], ENT_QUOTES, 'UTF-8') ?>">
				<label for="site-language"><?= htmlspecialchars($messages['language_label'], ENT_QUOTES, 'UTF-8') ?></label>
				<div class="language-select">
					<span class="language-flag">
					<img src="<?= htmlspecialchars($currentFlagIcon, ENT_QUOTES, 'UTF-8') ?>" alt="<?= htmlspecialchars($currentFlagAlt, ENT_QUOTES, 'UTF-8') ?>" height="20" width="28" loading="lazy" />
				</span>
					<select id="site-language" name="lang" class="language-select__input" onchange="this.form.submit()" aria-label="<?= htmlspecialchars($messages['language_toggle_hint'], ENT_QUOTES, 'UTF-8') ?>">
						<?php foreach ($languageOptions as $code => $option): ?>
							<option value="<?= htmlspecialchars($code, ENT_QUOTES, 'UTF-8') ?>" data-icon="<?= htmlspecialchars($option['icon'], ENT_QUOTES, 'UTF-8') ?>" <?= $code === $currentLocale ? 'selected' : '' ?>>
								<?= htmlspecialchars($option['label'], ENT_QUOTES, 'UTF-8') ?>
							</option>
						<?php endforeach; ?>
					</select>
					<button type="button" class="language-select__toggle" aria-hidden="true" tabindex="-1">
						<svg width="16" height="16" viewBox="0 0 16 16" aria-hidden="true" focusable="false">
							<path d="M4.2 5.6 8 9.4l3.8-3.8" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round" />
						</svg>
					</button>
					<noscript>
						<button type="submit" class="language-submit"><?= htmlspecialchars($messages['language_submit'], ENT_QUOTES, 'UTF-8') ?></button>
					</noscript>
				</div>
			</form>

		</section>
	</main>

	<script src="assets/js/app.js"></script>
</body>
</html>





