<?php
if (session_status() === PHP_SESSION_NONE) {
	session_start();
}
require_once __DIR__ . '/config/messages.php';
$messages = load_messages();

$isLoggedIn = isset($_SESSION['user']);
if (!$isLoggedIn) {
	$_SESSION['flash']['error'] = $messages['login_required'];
	header('Location: index.php');
	exit;
}

$username = htmlspecialchars($_SESSION['user']['username'] ?? 'user', ENT_QUOTES, 'UTF-8');
?>
<!DOCTYPE html>
<html lang="vi">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<title>Bảng điều khiển - Quản lý nhân sự</title>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/style.css" />
</head>
<body class="dashboard-body">
	<div class="dashboard-layout">
		<?php include __DIR__ . '/control_menu.php'; ?>

		<div class="dashboard-main">
			<?php include __DIR__ . '/control_header.php'; ?>

			<section class="metrics-grid">
				<article class="metric-card">
					<h4>Tổng nhân sự</h4>
					<p class="metric-value">2,500</p>
					<span class="metric-trend up">+4% so với tuần trước</span>
				</article>
				<article class="metric-card">
					<h4>Thời gian trung bình</h4>
					<p class="metric-value">123.5 giờ</p>
					<span class="metric-trend up">+3% so với tuần trước</span>
				</article>
				<article class="metric-card">
					<h4>Nhân sự nam</h4>
					<p class="metric-value">2,500</p>
					<span class="metric-trend up">+34% so với tuần trước</span>
				</article>
				<article class="metric-card">
					<h4>Nhân sự nữ</h4>
					<p class="metric-value">4,567</p>
					<span class="metric-trend down">-12% so với tuần trước</span>
				</article>
				<article class="metric-card">
					<h4>Hồ sơ mới</h4>
					<p class="metric-value">2,315</p>
					<span class="metric-trend up">+34% so với tuần trước</span>
				</article>
				<article class="metric-card">
					<h4>Kết nối nội bộ</h4>
					<p class="metric-value">7,325</p>
					<span class="metric-trend up">+8% so với tuần trước</span>
				</article>
			</section>

			<section class="panel-grid">
				<div class="panel wide">
					<header class="panel-header">
						<h3>Hoạt động mạng lưới</h3>
						<div class="panel-controls">
							<button class="panel-control" type="button"><span class="panel-icon" aria-hidden="true"><svg viewBox="0 0 24 24"><path d="M7 4v3" /><path d="M17 4v3" /><rect x="4" y="6.5" width="16" height="13" rx="2" /><path d="M4 11h16" /></svg></span><span>21/08/2025 - 19/09/2025</span></button>
						</div>
					</header>
					<div class="chart-area">
						<div class="chart-placeholder"></div>
					</div>
				</div>
				<div class="panel">
					<header class="panel-header">
						<h3>Chiến dịch nổi bật</h3>
					</header>
					<ul class="progress-list">
						<li><span>Facebook Campaign</span><span class="bar"><span style="width:76%"></span></span><strong>76%</strong></li>
						<li><span>Twitter Campaign</span><span class="bar"><span style="width:58%"></span></span><strong>58%</strong></li>
						<li><span>Conventional Media</span><span class="bar"><span style="width:32%"></span></span><strong>32%</strong></li>
						<li><span>Billboards</span><span class="bar"><span style="width:64%"></span></span><strong>64%</strong></li>
					</ul>
				</div>
			</section>

			<section class="panel-grid trio">
				<div class="panel">
					<header class="panel-header">
						<h3>Phiên bản ứng dụng</h3>
					</header>
					<ul class="progress-list compact">
						<li><span>v0.1.5.2</span><span class="bar"><span style="width:70%"></span></span><strong>123k</strong></li>
						<li><span>v0.1.5.3</span><span class="bar"><span style="width:42%"></span></span><strong>53k</strong></li>
						<li><span>v0.1.5.4</span><span class="bar"><span style="width:28%"></span></span><strong>23k</strong></li>
					</ul>
				</div>
				<div class="panel">
					<header class="panel-header">
						<h3>Thiết bị sử dụng</h3>
					</header>
					<div class="device-usage">
						<ul>
							<li><span class="dot ios"></span> iOS <strong>30%</strong></li>
							<li><span class="dot android"></span> Android <strong>40%</strong></li>
							<li><span class="dot web"></span> Web <strong>22%</strong></li>
							<li><span class="dot other"></span> Khác <strong>8%</strong></li>
						</ul>
					</div>
				</div>
				<div class="panel">
					<header class="panel-header">
						<h3>Cài đặt nhanh</h3>
					</header>
					<ul class="quick-settings">
						<li>Thông tin hồ sơ</li>
						<li>Gia hạn tự động</li>
						<li>Bảng lương</li>
						<li>Thông báo nội bộ</li>
						<li>Quản lý vai trò</li>
					</ul>
					<div class="gauge-placeholder">
						<div class="gauge"></div>
						<p>Hoàn thành hồ sơ 68%</p>
					</div>
				</div>
			</section>
		</div>
	</div>
	<script src="assets/js/app.js"></script>
</body>
</html>

