-- Tạo index để tối ưu hiệu suất truy vấn cho bảng Address
-- Chạy script này để cải thiện tốc độ load dữ liệu Tỉnh/Thành phố, Quận/Huyện, Phường/Xã

-- Tạo index cho Tinh_TP
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Address_Tinh_TP' AND object_id = OBJECT_ID('Address'))
BEGIN
    CREATE INDEX IX_Address_Tinh_TP ON Address(Tinh_TP);
    PRINT 'Đã tạo index IX_Address_Tinh_TP';
END
ELSE
BEGIN
    PRINT 'Index IX_Address_Tinh_TP đã tồn tại';
END
GO

-- Tạo index cho Quan_Huyen
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Address_Quan_Huyen' AND object_id = OBJECT_ID('Address'))
BEGIN
    CREATE INDEX IX_Address_Quan_Huyen ON Address(Quan_Huyen);
    PRINT 'Đã tạo index IX_Address_Quan_Huyen';
END
ELSE
BEGIN
    PRINT 'Index IX_Address_Quan_Huyen đã tồn tại';
END
GO

-- Tạo composite index cho query thường dùng (Tinh_TP -> Quan_Huyen)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Address_Tinh_TP_Quan_Huyen' AND object_id = OBJECT_ID('Address'))
BEGIN
    CREATE INDEX IX_Address_Tinh_TP_Quan_Huyen ON Address(Tinh_TP, Quan_Huyen);
    PRINT 'Đã tạo index IX_Address_Tinh_TP_Quan_Huyen';
END
ELSE
BEGIN
    PRINT 'Index IX_Address_Tinh_TP_Quan_Huyen đã tồn tại';
END
GO

-- Tạo composite index cho query Quan_Huyen -> Phuong_Xa
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Address_Quan_Huyen_Phuong_Xa' AND object_id = OBJECT_ID('Address'))
BEGIN
    CREATE INDEX IX_Address_Quan_Huyen_Phuong_Xa ON Address(Quan_Huyen, Phuong_Xa);
    PRINT 'Đã tạo index IX_Address_Quan_Huyen_Phuong_Xa';
END
ELSE
BEGIN
    PRINT 'Index IX_Address_Quan_Huyen_Phuong_Xa đã tồn tại';
END
GO

PRINT 'Hoàn thành tạo index cho bảng Address';

