# Hướng dẫn tối ưu hóa hiệu suất Document và GoDocument Tables

## Mục đích
File SQL này tạo các index để tăng tốc độ truy vấn dữ liệu Công văn đến (Document) và Công văn đi (GoDocument).

## Cách chạy

### Bước 1: Chạy SQL Script
1. Mở SQL Server Management Studio (SSMS)
2. Kết nối đến database của bạn
3. Mở file `create_document_indexes.sql`
4. Chạy script (F5 hoặc Execute)

### Bước 2: Kiểm tra kết quả
Script sẽ hiển thị thông báo cho từng index được tạo hoặc đã tồn tại.

## Các Index được tạo

### Cho bảng Document (Công văn đến):
1. **IX_Document_EffectiveDate**: Index trên cột `EffectiveDate DESC` - tối ưu ORDER BY
2. **IX_Document_EffectiveDate_Id**: Composite index `(EffectiveDate DESC, Id DESC)` - tối ưu ORDER BY kết hợp
3. **IX_Document_ID_Symbol**: Index trên cột `ID_Symbol` - tối ưu search
4. **IX_Document_TitleVi**: Index trên cột `TitleVi` - tối ưu search
5. **IX_Document_Issuer**: Index trên cột `Issuer` - tối ưu search
6. **IX_Document_ID_Company**: Index trên cột `ID_Company` - tối ưu JOIN
7. **IX_Document_ID_Category**: Index trên cột `ID_Category` - tối ưu JOIN

### Cho bảng GoDocument (Công văn đi):
1. **IX_GoDocument_EffectiveDate**: Index trên cột `EffectiveDate DESC` - tối ưu ORDER BY
2. **IX_GoDocument_EffectiveDate_Id**: Composite index `(EffectiveDate DESC, Id DESC)` - tối ưu ORDER BY kết hợp
3. **IX_GoDocument_ID_Symbol**: Index trên cột `ID_Symbol` - tối ưu search
4. **IX_GoDocument_TitleVi**: Index trên cột `TitleVi` - tối ưu search
5. **IX_GoDocument_Issuer**: Index trên cột `Issuer` - tối ưu search
6. **IX_GoDocument_ID_Company**: Index trên cột `ID_Company` - tối ưu JOIN

### Cho bảng Company và Category:
- **IX_Company_ID_Company**: Index trên cột `ID_Company` - tối ưu JOIN
- **IX_Category_ID_Category**: Index trên cột `ID_Category` - tối ưu JOIN

## Lưu ý

- Script sẽ không tạo lại index nếu đã tồn tại (sử dụng IF NOT EXISTS)
- Có thể chạy lại script nhiều lần mà không gây lỗi
- Index sẽ tự động được sử dụng bởi SQL Server khi truy vấn phù hợp

## Tối ưu hóa khác đã được áp dụng

1. **File Caching**: 
   - DocType và DocPageType được cache trong file system (1 giờ)
   - Cache files: `sys_get_temp_dir()/luna_cache/doctypes.json` và `docpagetypes.json`

2. **Query Optimization**: 
   - Sử dụng `WITH (NOLOCK)` cho read operations để giảm blocking
   - Áp dụng cho tất cả các bảng trong JOIN

3. **Index Strategy**:
   - Composite indexes cho ORDER BY phức tạp
   - Single column indexes cho search và JOIN

## Cải thiện hiệu suất dự kiến

- **Truy vấn không có search**: Tăng tốc 10-50 lần (tùy số lượng records)
- **Truy vấn có search**: Tăng tốc 5-20 lần (tùy pattern search)
- **JOIN operations**: Tăng tốc 5-10 lần
- **Load DocType/DocPageType**: Tăng tốc 100+ lần (từ cache)

## Vị trí cache files

Cache files được lưu tại: `sys_get_temp_dir()/luna_cache/`

- `doctypes.json`: Cache cho danh sách DocType
- `docpagetypes.json`: Cache cho danh sách DocPageType

Cache tự động hết hạn sau 1 giờ và sẽ được tạo lại khi cần.

