# Hướng dẫn tối ưu hóa hiệu suất Address Table

## Mục đích
File SQL này tạo các index để tăng tốc độ truy vấn dữ liệu Tỉnh/Thành phố, Quận/Huyện, và Phường/Xã từ bảng `Address`.

## Cách chạy

### Bước 1: Chạy SQL Script
1. Mở SQL Server Management Studio (SSMS)
2. Kết nối đến database của bạn
3. Mở file `create_address_indexes.sql`
4. Chạy script (F5 hoặc Execute)

### Bước 2: Kiểm tra kết quả
Script sẽ hiển thị thông báo:
- "Đã tạo index IX_Address_Tinh_TP"
- "Đã tạo index IX_Address_Quan_Huyen"
- "Đã tạo index IX_Address_Tinh_TP_Quan_Huyen"
- "Đã tạo index IX_Address_Quan_Huyen_Phuong_Xa"
- "Hoàn thành tạo index cho bảng Address"

## Các Index được tạo

1. **IX_Address_Tinh_TP**: Index trên cột `Tinh_TP` để tối ưu truy vấn theo Tỉnh/Thành phố
2. **IX_Address_Quan_Huyen**: Index trên cột `Quan_Huyen` để tối ưu truy vấn theo Quận/Huyện
3. **IX_Address_Tinh_TP_Quan_Huyen**: Composite index để tối ưu truy vấn Tỉnh/Thành phố -> Quận/Huyện
4. **IX_Address_Quan_Huyen_Phuong_Xa**: Composite index để tối ưu truy vấn Quận/Huyện -> Phường/Xã

## Lưu ý

- Script sẽ không tạo lại index nếu đã tồn tại (sử dụng IF NOT EXISTS)
- Có thể chạy lại script nhiều lần mà không gây lỗi
- Index sẽ tự động được sử dụng bởi SQL Server khi truy vấn phù hợp

## Tối ưu hóa khác đã được áp dụng

1. **File Caching**: Dữ liệu được cache trong file system (1 giờ)
2. **JavaScript Caching**: Dữ liệu được cache trong memory của browser
3. **Prevent Duplicate Requests**: Tránh gửi nhiều request cùng lúc cho cùng một dữ liệu
4. **Query Optimization**: Sử dụng `WITH (NOLOCK)` cho read operations

## Vị trí cache files

Cache files được lưu tại: `sys_get_temp_dir()/luna_cache/`

- `districts_[hash].json`: Cache cho danh sách Quận/Huyện
- `wards_[hash].json`: Cache cho danh sách Phường/Xã

Cache tự động hết hạn sau 1 giờ và sẽ được tạo lại khi cần.

