﻿<?php
// Prevent direct access
if (!defined('LUNA_APP')) {
	http_response_code(403);
	exit('Forbidden');
}
if (!isset($messages) || !is_array($messages)) {
	require_once __DIR__ . '/config/messages.php';
	$messages = load_messages();
}
$currentPage = isset($page) ? (string)$page : (isset($_GET['company']) ? 'company' : (isset($_GET['category']) ? 'category' : (isset($_GET['incoming']) ? 'incoming' : (isset($_GET['outgoing']) ? 'outgoing' : (isset($_GET['zalo']) ? 'zalo' : (isset($_GET['attendance']) ? 'attendance' : (isset($_GET['dashboard']) ? 'dashboard' : 'dashboard')))))));
$isCompany = ($currentPage === 'company');
$isCategory = ($currentPage === 'category');
$isIncoming = ($currentPage === 'incoming');
$isOutgoing = ($currentPage === 'outgoing');
$isZalo = ($currentPage === 'zalo' || $currentPage === 'zalo_log');
$isAttendance = ($currentPage === 'attendance');
$homeActiveClass = ($isCompany || $isCategory || $isIncoming || $isOutgoing || $isZalo || $isAttendance) ? '' : 'active';
// Keep group marked active for management pages (company/category/incoming/outgoing)
$mgmtClasses = 'has-submenu' . (($isCompany || $isCategory || $isIncoming || $isOutgoing) ? ' active' : '');
$mgmtAria = 'false';
// Keep declaration parent highlighted but not expanded
$declParentClasses = 'declaration-parent has-submenu' . (($isCompany || $isCategory) ? ' active' : '');
$declAria = 'false';
// Admin group active for Zalo and Attendance
$adminClasses = 'has-submenu' . (($isZalo || $isAttendance) ? ' active' : '');
$adminAria = 'false';
// Admin declaration parent for Zalo submenu
$adminDeclParentClasses = 'admin-declaration-parent has-submenu' . (($isZalo) ? ' active' : '');
$adminDeclAria = 'false';
// Time clock machine parent for attendance submenu (same structure as admin-declaration)
$mccParentClasses = 'admin-declaration-parent has-submenu' . (($isAttendance) ? ' active' : '');
$mccAria = 'false';
?>
<aside class="dashboard-sidebar" style="background: rgba(11, 31, 34, 0.92) !important; background-color: rgba(11, 31, 34, 0.92) !important; opacity: 0; visibility: hidden;">
	<div class="sidebar-brand">
		<div class="brand-logo">
			<img src="assets/img/logo.png" alt="<?= htmlspecialchars($messages['control_brand_title'], ENT_QUOTES, 'UTF-8') ?>" />
		</div>
		<div class="brand-meta">
			<h2><?= htmlspecialchars($messages['control_brand_title'], ENT_QUOTES, 'UTF-8') ?></h2>
			<p><?= htmlspecialchars($messages['control_brand_subtitle'], ENT_QUOTES, 'UTF-8') ?></p>
		</div>
	</div>
	<div class="sidebar-separator"></div>
	<nav class="sidebar-nav">
		<h3 class="nav-heading"><?= htmlspecialchars($messages['control_nav_heading'], ENT_QUOTES, 'UTF-8') ?></h3>
		<ul>
			<li class="<?= $homeActiveClass ?>">
				<a href="index.php" class="nav-root-link">
					<span class="nav-icon" aria-hidden="true">
						<svg viewBox="0 0 24 24"><path d="M3 10.5L12 4l9 6.5" /><path d="M5 11.75V20h5.75v-4.5h2.5V20H19v-8.25" /></svg>
					</span>
					<span class="nav-label"><?= htmlspecialchars($messages['control_nav_home'], ENT_QUOTES, 'UTF-8') ?></span>
				</a>
			</li>
			<li class="<?= $mgmtClasses ?>" data-submenu="management">
				<div class="submenu-trigger" role="button" tabindex="0" aria-expanded="<?= $mgmtAria ?>" aria-controls="submenu-management">
					<span class="nav-icon" aria-hidden="true">
						<svg viewBox="0 0 24 24"><path d="M16 4h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h2" /><rect x="8" y="2" width="8" height="4" rx="1" ry="1" /><path d="M12 11h4" /><path d="M12 16h4" /><path d="M8 11h.01" /><path d="M8 16h.01" /></svg>
					</span>
					<span class="nav-label"><?= htmlspecialchars($messages['control_nav_management'], ENT_QUOTES, 'UTF-8') ?></span>
					<span class="nav-caret" aria-hidden="true">
						<svg viewBox="0 0 16 16"><path d="M4.5 6l3.5 4 3.5-4" /></svg>
					</span>
				</div>
				<ul class="submenu" id="submenu-management" role="menu">
				<li role="none" class="<?= $declParentClasses ?>">
					<a class="submenu-link declaration-trigger<?= ($isCompany || $isCategory) ? ' is-selected' : '' ?>" href="#" role="menuitem" data-declaration-menu="true" aria-expanded="<?= $declAria ?>">
						<span class="submenu-icon" aria-hidden="true">
							<svg viewBox="0 0 24 24"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" /><polyline points="14,2 14,8 20,8" /><line x1="16" y1="13" x2="8" y2="13" /><line x1="16" y1="17" x2="8" y2="17" /><polyline points="10,9 9,9 8,9" /></svg>
						</span>
						<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_declaration'], ENT_QUOTES, 'UTF-8') ?></span>
						<span class="nav-caret" aria-hidden="true">
							<svg viewBox="0 0 16 16"><path d="M4.5 6l3.5 4 3.5-4" /></svg>
						</span>
					</a>
					
					<!-- Declaration submenu - moved inside li for proper nesting -->
					<div class="declaration-submenu" id="declaration-submenu">
						<div class="declaration-submenu-content">
							<a href="index.php?company" class="declaration-submenu-item<?= $isCompany ? ' is-selected' : '' ?>">
								<span class="declaration-submenu-icon">
									<svg viewBox="0 0 24 24"><path d="M3 21h18" /><path d="M5 21V7l8-4v18" /><path d="M19 21V11l-6-4" /></svg>
								</span>
								<span class="declaration-submenu-label"><?= htmlspecialchars($messages['control_nav_company'], ENT_QUOTES, 'UTF-8') ?></span>
							</a>
							<a href="index.php?category" class="declaration-submenu-item<?= $isCategory ? ' is-selected' : '' ?>">
								<span class="declaration-submenu-icon">
									<svg viewBox="0 0 24 24"><path d="M4 6h16" /><path d="M4 12h16" /><path d="M4 18h16" /></svg>
								</span>
								<span class="declaration-submenu-label"><?= htmlspecialchars($messages['control_nav_category'], ENT_QUOTES, 'UTF-8') ?></span>
							</a>
						</div>
					</div>
				</li>
                    <li role="none" class="<?= 'has-submenu operations-parent' . (($isIncoming || $isOutgoing) ? ' active' : '') ?>">
                        <a class="submenu-link operations-trigger<?= ($isIncoming || $isOutgoing) ? ' is-selected' : '' ?>" href="#" role="menuitem" aria-expanded="false">
                            <span class="submenu-icon" aria-hidden="true">
                                <svg viewBox="0 0 24 24"><circle cx="12" cy="12" r="3" /><path d="M12 1v6m0 6v6m11-7h-6m-6 0H1" /></svg>
                            </span>
                            <span class="submenu-label"><?= htmlspecialchars($messages['control_nav_operations'], ENT_QUOTES, 'UTF-8') ?></span>
                            <span class="nav-caret" aria-hidden="true">
                                <svg viewBox="0 0 16 16"><path d="M4.5 6l3.5 4 3.5-4" /></svg>
                            </span>
                        </a>
                        
                        <!-- Operations submenu - moved inside li for proper nesting -->
                        <div class="operations-submenu" id="operations-submenu">
                            <div class="declaration-submenu-content">
                                <a href="index.php?outgoing" class="declaration-submenu-item<?= $isOutgoing ? ' is-selected' : '' ?>">
                                    <span class="declaration-submenu-icon">
                                        <svg viewBox="0 0 24 24"><path d="M3 12h18" /><path d="M13 5l7 7-7 7" /></svg>
                                    </span>
                                    <span class="declaration-submenu-label"><?= htmlspecialchars($messages['control_nav_outgoing'], ENT_QUOTES, 'UTF-8') ?></span>
                                </a>
                                <a href="index.php?incoming" class="declaration-submenu-item<?= $isIncoming ? ' is-selected' : '' ?>">
                                    <span class="declaration-submenu-icon">
                                        <svg viewBox="0 0 24 24"><path d="M21 12H3" /><path d="M11 19l-7-7 7-7" /></svg>
                                    </span>
                                    <span class="declaration-submenu-label"><?= htmlspecialchars($messages['control_nav_incoming'], ENT_QUOTES, 'UTF-8') ?></span>
                                </a>
                            </div>
                        </div>
                    </li>
					<li role="none">
						<a class="submenu-link" href="#" role="menuitem">
							<span class="submenu-icon" aria-hidden="true">
								<svg viewBox="0 0 24 24"><circle cx="11" cy="11" r="8" /><path d="m21 21-4.35-4.35" /></svg>
							</span>
							<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_search_records'], ENT_QUOTES, 'UTF-8') ?></span>
						</a>
					</li>
				</ul>
			</li>
			<li class="<?= $adminClasses ?>" data-submenu="admin">
				<div class="submenu-trigger" role="button" tabindex="0" aria-expanded="<?= $adminAria ?>" aria-controls="submenu-admin">
					<span class="nav-icon" aria-hidden="true">
						<svg viewBox="0 0 24 24"><path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2" /><circle cx="9" cy="7" r="4" /><path d="M22 21v-2a4 4 0 0 0-3-3.87" /><path d="M16 3.13a4 4 0 0 1 0 7.75" /></svg>
					</span>
					<span class="nav-label"><?= htmlspecialchars($messages['control_nav_admin'], ENT_QUOTES, 'UTF-8') ?></span>
					<span class="nav-caret" aria-hidden="true">
						<svg viewBox="0 0 16 16"><path d="M4.5 6l3.5 4 3.5-4" /></svg>
					</span>
				</div>
				<ul class="submenu" id="submenu-admin" role="menu">
					<li role="none">
						<a class="submenu-link" href="#" role="menuitem">
							<span class="submenu-icon" aria-hidden="true">
								<svg viewBox="0 0 24 24"><path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9" /><path d="M13.73 21a2 2 0 0 1-3.46 0" /></svg>
							</span>
							<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_notifications'], ENT_QUOTES, 'UTF-8') ?></span>
						</a>
					</li>
					<li role="none">
						<a class="submenu-link" href="#" role="menuitem">
							<span class="submenu-icon" aria-hidden="true">
								<svg viewBox="0 0 24 24"><path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2" /><circle cx="9" cy="7" r="4" /><path d="M22 21v-2a4 4 0 0 0-3-3.87" /><path d="M16 3.13a4 4 0 0 1 0 7.75" /></svg>
							</span>
							<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_manage_employees'], ENT_QUOTES, 'UTF-8') ?></span>
						</a>
					</li>
					<li role="none">
						<a class="submenu-link" href="#" role="menuitem">
							<span class="submenu-icon" aria-hidden="true">
								<svg viewBox="0 0 24 24"><path d="M16 4h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h2" /><rect x="8" y="2" width="8" height="4" rx="1" ry="1" /><path d="M12 11h4" /><path d="M12 16h4" /><path d="M8 11h.01" /><path d="M8 16h.01" /></svg>
							</span>
							<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_employee_list'], ENT_QUOTES, 'UTF-8') ?></span>
						</a>
					</li>
					<li role="none">
						<a class="submenu-link" href="#" role="menuitem">
							<span class="submenu-icon" aria-hidden="true">
								<svg viewBox="0 0 24 24"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" /><polyline points="14,2 14,8 20,8" /><line x1="16" y1="13" x2="8" y2="13" /><line x1="16" y1="17" x2="8" y2="17" /><polyline points="10,9 9,9 8,9" /></svg>
							</span>
							<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_manage_forms'], ENT_QUOTES, 'UTF-8') ?></span>
						</a>
					</li>
					<li role="none" class="<?= $adminDeclParentClasses ?>">
						<a class="submenu-link admin-declaration-trigger<?= ($isZalo) ? ' is-selected' : '' ?>" href="#" role="menuitem" data-admin-declaration-menu="true" aria-expanded="<?= $adminDeclAria ?>">
							<span class="submenu-icon" aria-hidden="true">
								<svg viewBox="0 0 24 24"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" /><polyline points="14,2 14,8 20,8" /><line x1="16" y1="13" x2="8" y2="13" /><line x1="16" y1="17" x2="8" y2="17" /><polyline points="10,9 9,9 8,9" /></svg>
							</span>
							<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_admin_declaration'], ENT_QUOTES, 'UTF-8') ?></span>
							<span class="nav-caret" aria-hidden="true">
								<svg viewBox="0 0 16 16"><path d="M4.5 6l3.5 4 3.5-4" /></svg>
							</span>
						</a>
						
						<!-- Admin Declaration submenu -->
						<div class="admin-declaration-submenu" id="admin-declaration-submenu">
							<div class="declaration-submenu-content">
								<a href="index.php?zalo" class="declaration-submenu-item<?= ($currentPage === 'zalo') ? ' is-selected' : '' ?>">
									<span class="declaration-submenu-icon">
										<svg viewBox="0 0 24 24"><path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"/><path d="M8 9h8"/><path d="M8 13h6"/></svg>
									</span>
									<span class="declaration-submenu-label"><?= htmlspecialchars($messages['control_nav_zalo'], ENT_QUOTES, 'UTF-8') ?></span>
								</a>
							</div>
						</div>
					</li>
					<li role="none">
						<a class="submenu-link" href="#" role="menuitem">
							<span class="submenu-icon" aria-hidden="true">
								<svg viewBox="0 0 24 24"><path d="M3 3v18h18" /><path d="M18.7 8l-5.1 5.2-2.8-2.7L7 14.3" /></svg>
							</span>
							<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_monthly_report'], ENT_QUOTES, 'UTF-8') ?></span>
						</a>
					</li>
					<li role="none">
						<a class="submenu-link" href="#" role="menuitem">
							<span class="submenu-icon" aria-hidden="true">
								<svg viewBox="0 0 24 24"><circle cx="12" cy="12" r="3" /><path d="M12 1v6m0 6v6m11-7h-6m-6 0H1" /></svg>
							</span>
							<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_hr_processing'], ENT_QUOTES, 'UTF-8') ?></span>
						</a>
					</li>
					<li role="none" class="<?= $mccParentClasses ?>">
						<a class="submenu-link admin-declaration-trigger<?= ($isAttendance) ? ' is-selected' : '' ?>" href="#" role="menuitem" data-admin-declaration-menu="true" aria-expanded="<?= $mccAria ?>">
							<span class="submenu-icon" aria-hidden="true">
								<svg viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" /><polyline points="12,6 12,12 16,14" /></svg>
							</span>
							<span class="submenu-label"><?= htmlspecialchars($messages['control_nav_mcc_processing'], ENT_QUOTES, 'UTF-8') ?></span>
							<span class="nav-caret" aria-hidden="true">
								<svg viewBox="0 0 16 16"><path d="M4.5 6l3.5 4 3.5-4" /></svg>
							</span>
						</a>
						
						<!-- Time Clock Machine submenu -->
						<div class="admin-declaration-submenu" id="mcc-submenu">
							<div class="declaration-submenu-content">
								<a href="index.php?attendance" class="declaration-submenu-item<?= $isAttendance ? ' is-selected' : '' ?>">
									<span class="declaration-submenu-icon">
										<svg viewBox="0 0 24 24"><path d="M16 4h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h2" /><rect x="8" y="2" width="8" height="4" rx="1" ry="1" /><path d="M12 11h4" /><path d="M12 16h4" /><path d="M8 11h.01" /><path d="M8 16h.01" /></svg>
									</span>
									<span class="declaration-submenu-label"><?= htmlspecialchars($messages['control_nav_attendance_data'], ENT_QUOTES, 'UTF-8') ?></span>
								</a>
							</div>
						</div>
					</li>
				</ul>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M7 4v3" /><path d="M17 4v3" /><rect x="4" y="7" width="16" height="13" rx="2" /><path d="M4 11h16" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_planner'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M6 18v-6" /><path d="M12 18V9" /><path d="M18 18v-9" /><path d="M4 20h16" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_reports'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M6.5 8.5 12 5l5.5 3.5-5.5 3.5-5.5-3.5Z" /><path d="M6.5 15.5 12 19l5.5-3.5" /><path d="M6.5 12 12 15l5.5-3" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_ui'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><rect x="4" y="6" width="16" height="12" rx="2" /><path d="M4 12h16" /><path d="M12 6v12" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_tables'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M12 4a8 8 0 1 0 8 8h-8V4Z" /><path d="M12 4a8 8 0 0 1 8 8" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_data'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><rect x="4" y="5" width="7" height="7" rx="1.5" /><rect x="13" y="5" width="7" height="4" rx="1.5" /><rect x="13" y="11" width="7" height="8" rx="1.5" /><rect x="4" y="13" width="7" height="6" rx="1.5" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_nav_layouts'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
		</ul>
	</nav>
	<div class="sidebar-footer">
		<h3 class="nav-heading"><?= htmlspecialchars($messages['control_footer_heading'], ENT_QUOTES, 'UTF-8') ?></h3>
		<ul>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M7 3h8l4 4v14H7a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2Z" /><path d="M15 3v4h4" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_footer_pages'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M12 4.5 13.5 8 17 9.5 13.5 11 12 14.5 10.5 11 7 9.5 10.5 8Z" /><path d="M6 15.5 7 17l-1 1 1.5-.25L8 19l.5-1.75L10 17l-1-.75" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_footer_extras'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
			<li>
				<span class="nav-icon" aria-hidden="true">
					<svg viewBox="0 0 24 24"><path d="M5 6h14" /><path d="M5 12h9" /><path d="M5 18h6" /><circle cx="18" cy="12" r="1.5" /><circle cx="16" cy="18" r="1" /></svg>
				</span>
				<span class="nav-label"><?= htmlspecialchars($messages['control_footer_multilevel'], ENT_QUOTES, 'UTF-8') ?></span>
			</li>
		</ul>
		<div class="sidebar-meta">
			<p><?= htmlspecialchars($messages['control_footer_copyright'], ENT_QUOTES, 'UTF-8') ?></p>
		</div>
	</div>
	
</aside>
<script>
// Ensure sidebar background is correct and show it when CSS is loaded
(function() {
	var sidebar = document.querySelector('.dashboard-sidebar');
	if (sidebar) {
		sidebar.style.setProperty('background', 'rgba(11, 31, 34, 0.92)', 'important');
		sidebar.style.setProperty('background-color', 'rgba(11, 31, 34, 0.92)', 'important');
	}
	function showSidebar() {
		if (sidebar) {
			sidebar.style.opacity = '1';
			sidebar.style.visibility = 'visible';
		}
	}
	// Show sidebar when CSS is loaded
	if (document.readyState === 'complete' || document.readyState === 'interactive') {
		setTimeout(showSidebar, 50);
	} else {
		window.addEventListener('load', showSidebar);
		document.addEventListener('DOMContentLoaded', function() {
			setTimeout(showSidebar, 100);
		});
	}
})();
</script>
