﻿<?php
if (!defined('LUNA_APP')) {
    define('LUNA_APP', true);
}
if (session_status() === PHP_SESSION_NONE) {
	session_start();
}
require_once __DIR__ . '/config/messages.php';
$messages = load_messages();
// Prepare flash data for pages that use it directly (dashboard). For login page,
// we must not clear flashes here because login.php will read and display them.
$flashData = [
    'success' => $_SESSION['flash']['success'] ?? null,
    'error' => $_SESSION['flash']['error'] ?? null,
];
// Clear flash after reading so it doesn't persist across refresh
if (isset($_SESSION['flash'])) {
    unset($_SESSION['flash']['success'], $_SESSION['flash']['error']);
    if (empty($_SESSION['flash'])) { unset($_SESSION['flash']); }
}

$isLoggedIn = isset($_SESSION['user']);

// Route based on query string
// Simple router via query string
$page = null;
if (isset($_GET['dashboard'])) {
    $page = 'dashboard';
} elseif (isset($_GET['company'])) {
    $page = 'company';
} elseif (isset($_GET['category'])) {
    $page = 'category';
} elseif (isset($_GET['outgoing'])) {
    $page = 'outgoing';
} elseif (isset($_GET['incoming'])) {
    // Check if it's the log viewer
    if ($_GET['incoming'] === 'log') {
        $page = 'incoming_log';
    } else {
        $page = 'incoming';
    }
} elseif (isset($_GET['zalo'])) {
    // Check if it's the log viewer
    if ($_GET['zalo'] === 'log') {
        $page = 'zalo_log';
    } else {
        $page = 'zalo';
    }
} elseif (isset($_GET['attendance'])) {
    $page = 'attendance';
}

if (!$isLoggedIn) {
	// Not logged in -> show login UI
	require __DIR__ . '/login.php';
	exit;
}

// Logged in: render shell and include sections
?>
<!DOCTYPE html>
<html lang="vi">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
	<title>Luna HR</title>
	<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
	<link rel="stylesheet" href="assets/css/style.css" />
	<link rel="stylesheet" href="assets/css/pdfjs.css" />
</head>
<body class="dashboard-body">
    <div id="page-loader" class="page-loader show">
        <div class="loader-spinner" aria-hidden="true"></div>
    </div>
	<div class="dashboard-layout">
		<?php if (!defined('LUNA_APP')) define('LUNA_APP', true); include __DIR__ . '/control_menu.php'; ?>
		<div class="dashboard-main">
			<?php include __DIR__ . '/control_header.php'; ?>
			<?php
			if (!defined('LUNA_APP')) define('LUNA_APP', true);
            if ($page === 'company') {
                include __DIR__ . '/profile_conpany.php';
            } elseif ($page === 'category') {
                include __DIR__ . '/profile_category.php';
            } elseif ($page === 'outgoing') {
                include __DIR__ . '/profile_outgoing.php';
            } elseif ($page === 'incoming') {
                include __DIR__ . '/profile_incoming.php';
            } elseif ($page === 'incoming_log') {
                include __DIR__ . '/profile_incoming_log.php';
            } elseif ($page === 'zalo') {
                include __DIR__ . '/profile_zalo.php';
            } elseif ($page === 'zalo_log') {
                include __DIR__ . '/profile_zalo_log.php';
            } elseif ($page === 'attendance') {
                include __DIR__ . '/profile_attendance.php';
            } else {
				include __DIR__ . '/dashboard.php';
			}
			?>
		</div>
	</div>
    <script src="assets/js/app.js?v=<?php echo time(); ?>"></script>
    <script>
    window.__FLASH__ = <?php echo json_encode($flashData, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>;
    window.__MESSAGES__ = <?php echo json_encode($messages, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); ?>;
    </script>
    <script>
    // Hide loader when page is fully ready
    function hideLoader() {
        var loader = document.getElementById('page-loader');
        if (loader) loader.classList.remove('show');
    }

    // Hide loader when page is fully ready
    window.addEventListener('load', hideLoader);

    // Hide loader when page is shown from bfcache (back/forward button)
    window.addEventListener('pageshow', function(event) {
        // The event.persisted property is true if the page is loaded from cache
        if (event.persisted) {
            hideLoader();
        }
    });

    // Show loader on navigation clicks to simulate loading state
    (function () {
        var loader = document.getElementById('page-loader');
        function show() { if (loader) loader.classList.add('show'); }
        // Delegate for internal links
        document.addEventListener('click', function (e) {
            var link = e.target.closest('a');
            if (!link) return;
            var href = link.getAttribute('href') || '';
            var isInternal = href && !/^https?:\/\//i.test(href) && !href.startsWith('mailto:') && !href.startsWith('#');
            if (isInternal) {
                show();
            }
        }, true);
    })();
    </script>
</body>
</html>





