-- Bảng lưu lịch sử xuất file công văn
-- Chạy script này nếu muốn theo dõi lịch sử xuất file

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'DocumentExport')
BEGIN
    CREATE TABLE DocumentExport (
        Id INT IDENTITY(1,1) PRIMARY KEY,
        DocumentId INT NOT NULL,
        Quantity INT NOT NULL,
        Recipient NVARCHAR(10),  -- MSNV người nhận
        Reason NVARCHAR(500),    -- Lý do xuất
        ExportDate DATETIME DEFAULT GETDATE(),
        ExportedBy NVARCHAR(10), -- MSNV người xuất
        CONSTRAINT FK_DocumentExport_Document FOREIGN KEY (DocumentId) 
            REFERENCES Document(Id) ON DELETE CASCADE
    );
    
    PRINT 'Đã tạo bảng DocumentExport thành công';
END
ELSE
BEGIN
    PRINT 'Bảng DocumentExport đã tồn tại';
END
GO

-- Tạo index để tăng hiệu suất truy vấn
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_DocumentExport_DocumentId' AND object_id = OBJECT_ID('DocumentExport'))
BEGIN
    CREATE INDEX IX_DocumentExport_DocumentId ON DocumentExport(DocumentId);
    PRINT 'Đã tạo index IX_DocumentExport_DocumentId';
END
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_DocumentExport_ExportDate' AND object_id = OBJECT_ID('DocumentExport'))
BEGIN
    CREATE INDEX IX_DocumentExport_ExportDate ON DocumentExport(ExportDate DESC);
    PRINT 'Đã tạo index IX_DocumentExport_ExportDate';
END
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_DocumentExport_Recipient' AND object_id = OBJECT_ID('DocumentExport'))
BEGIN
    CREATE INDEX IX_DocumentExport_Recipient ON DocumentExport(Recipient);
    PRINT 'Đã tạo index IX_DocumentExport_Recipient';
END
GO




