<?php
if (!defined('LUNA_APP')) {
    http_response_code(403);
    exit('Forbidden');
}

require_once __DIR__ . '/config/messages.php';
$messages = $messages ?? load_messages();

// Simple flash helper
function set_flash(string $type, string $msg): void {
    if (session_status() === PHP_SESSION_NONE) session_start();
    $_SESSION['flash'][$type] = $msg;
}

$logs = [];
$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fetch_attendance'])) {
    // Device configuration (fixed per request)
    $deviceIp = '192.168.1.88';
    $devicePort = 4370;

    require_once __DIR__ . '/lib/ZKLibrary.php';
    $zk = new ZKLibrary($deviceIp, $devicePort);
    if (!$zk->connect()) {
        $error = 'Không thể kết nối tới máy chấm công ('.$deviceIp.':'.$devicePort.').';
    } else {
        $zk->disableDevice();
        $logs = $zk->getAttendance();
        $zk->enableDevice();
        $zk->disconnect();
        if (!$logs) {
            $error = 'Không nhận được dữ liệu chấm công nào.';
        }
    }
}
?>

<section class="dashboard-section">
    <div class="section-header">
        <div class="section-title">
            <h2>Dữ liệu chấm công</h2>
            <p>Kết nối máy chấm công và lấy dữ liệu về hệ thống</p>
        </div>
        <div class="section-actions">
            <form method="post" style="display:inline">
                <button type="submit" name="fetch_attendance" class="btn btn-primary">
                    Lấy dữ liệu từ máy
                </button>
            </form>
        </div>
    </div>

    <?php if ($error): ?>
    <div class="alert alert-danger" role="alert" style="margin-bottom:12px;">
        <?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?>
    </div>
    <?php endif; ?>

    <div class="section-content">
        <div class="table-card">
            <div class="table-responsive">
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>Mã nhân viên</th>
                            <th>Thời gian</th>
                            <th>Kiểu xác thực</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($logs)): ?>
                            <?php foreach ($logs as $row): ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['pin'] ?? '', ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars($row['datetime'] ?? '', ENT_QUOTES, 'UTF-8') ?></td>
                                    <td><?= htmlspecialchars($row['verify'] ?? '', ENT_QUOTES, 'UTF-8') ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="3" style="text-align:center;opacity:.7;">Chưa có dữ liệu hiển thị</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>





