<?php
/**
 * HƯỚNG DẪN SỬ DỤNG FUNCTION sendzalo()
 * 
 * Function sendzalo() giờ đã tự động tìm bot phù hợp:
 * 1. Nếu user đã có trong DataWork → Dùng bot được gán
 * 2. Nếu user chưa có trong DataWork → Tự động dùng bot đầu tiên
 * 
 * Cực kỳ đơn giản, chỉ cần 1 dòng code!
 */

// Include service
require_once __DIR__ . '/service.php';

// ==========================================
// CÁCH 1: GỬI NGAY KHÔNG CẦN DATABASE LOOKUP
// ==========================================

// Chỉ cần User ID và Message
$userId = '70c8847eaf3d46631f2c';  // Zalo User ID
$message = 'Hello từ Luna System!';

$result = sendzalo($userId, $message);

if ($result) {
    echo "✅ Gửi thành công!";
} else {
    echo "❌ Gửi thất bại: " . zalo_get_last_error();
}


// ==========================================
// CÁCH 2: GỬI VỚI DYNAMIC CONTENT
// ==========================================

$userName = "Sang Phan";
$documentNumber = "CV123/2025";

$message = "Xin chào {$userName},\n\n";
$message .= "Công văn số {$documentNumber} đã được tiếp nhận.\n";
$message .= "Thời gian: " . date('H:i:s d/m/Y') . "\n\n";
$message .= "Trân trọng!";

sendzalo($userId, $message);


// ==========================================
// CÁCH 3: GỬI TRONG LOOP
// ==========================================

$users = [
    '70c8847eaf3d46631f2c',
    'abc123xyz456',
    'user_id_3'
];

foreach ($users as $uid) {
    $sent = sendzalo($uid, "Thông báo hệ thống quan trọng!");
    
    if ($sent) {
        echo "✅ Đã gửi cho user: {$uid}\n";
    } else {
        echo "❌ Lỗi gửi cho user {$uid}: " . zalo_get_last_error() . "\n";
    }
    
    // Delay để tránh spam
    sleep(1);
}


// ==========================================
// CÁCH 4: GỬI THÔNG BÁO CÔNG VĂN ĐẾN
// ==========================================

function notifyIncomingDocument($zaloUserId, $docData) {
    $message = "📥 CÔNG VĂN ĐẾN MỚI\n\n";
    $message .= "Số hiệu: " . $docData['symbol'] . "\n";
    $message .= "Từ: " . $docData['sender'] . "\n";
    $message .= "Ngày: " . $docData['date'] . "\n";
    $message .= "Trích yếu: " . $docData['summary'] . "\n\n";
    $message .= "Vui lòng kiểm tra hệ thống!";
    
    return sendzalo($zaloUserId, $message);
}

// Usage
$docInfo = [
    'symbol' => 'CV123/2025',
    'sender' => 'Sở Tài Chính',
    'date' => '10/10/2025',
    'summary' => 'Về việc báo cáo tài chính quý III'
];

notifyIncomingDocument('70c8847eaf3d46631f2c', $docInfo);


// ==========================================
// CÁCH 5: GỬI VỚI ERROR HANDLING
// ==========================================

try {
    $result = sendzalo('70c8847eaf3d46631f2c', 'Test message');
    
    if (!$result) {
        $error = zalo_get_last_error();
        
        // Log error
        error_log("Zalo send failed: {$error}");
        
        // Send email backup nếu Zalo fail
        mail('admin@example.com', 'Zalo Failed', $error);
        
        // Hoặc lưu vào database để retry sau
        saveFailedMessage($userId, $message, $error);
    }
} catch (Exception $e) {
    error_log("Exception: " . $e->getMessage());
}


// ==========================================
// CÁCH 6: GỬI VỚI BOT CỤ THỂ (ADVANCED)
// ==========================================

// Nếu bạn muốn chỉ định bot cụ thể thay vì auto
$botToken = '1033249594902632569:udrWfKKlga...';
sendzalo_direct($botToken, $userId, $message);


// ==========================================
// LƯU Ý QUAN TRỌNG
// ==========================================

/*
 * 1. User phải chat với bot ít nhất 1 lần trước
 *    - Mở Zalo → Tìm bot (dùng QR code)
 *    - Gửi tin nhắn "Hi" cho bot
 *    - Sau đó mới có thể nhận tin từ server
 * 
 * 2. User ID lấy từ đâu?
 *    - Vào trang Zalo Management
 *    - Click "Lấy ID" trên bot
 *    - Click "Bắt đầu lắng nghe"
 *    - User gửi tin nhắn → Xem ID hiển thị
 * 
 * 3. Giới hạn API
 *    - Miễn phí: 3000 tin/tháng
 *    - Không spam quá nhanh (delay 1s giữa các tin)
 * 
 * 4. Format tin nhắn
 *    - Dùng \n để xuống dòng
 *    - Tối đa 2000 ký tự
 *    - Hỗ trợ Unicode (Tiếng Việt ok)
 */
?>


