<?php
if (!defined('LUNA_MSG_INCLUDE')) {
    http_response_code(403);
    exit('Forbidden');
}
return [
    'session_invalid' => 'Session is invalid. Please try again.',
    'credentials_required' => 'Please enter both employee code and password.',
    'database_connection_failed' => 'Unable to connect to the database server. Please try again later.',
    'database_query_failed' => 'A database query error occurred. Please try again.',
    'invalid_credentials' => 'Incorrect username or password.',
    'login_success' => 'Signed in successfully!',
    'login_required' => 'Please sign in to continue.',
    'logout_success' => 'You have signed out.',
    'language_label' => 'Language',
    'language_vietnamese' => 'Vietnamese',
    'language_english' => 'English',
    'language_submit' => 'Change',
    'language_toggle_hint' => 'Select display language',
    'page_title' => 'Sign in - Human Resource Management',
    'brand_heading' => 'Login Systems',
    'brand_subheading' => 'Welcome back!',
    'employee_code_label' => 'Employee code',
    'employee_code_placeholder' => 'Example: 00092',
    'password_label' => 'Password',
    'password_placeholder' => '••••••',
    'toggle_password_show' => 'Show password',
    'toggle_password_hide' => 'Hide password',
    'login_button' => 'Sign in',
    'forgot_link' => 'Forgot login?',
    'demo_hint' => 'Demo account: <strong>NV001</strong> / <strong>123456</strong>',
    'control_brand_title' => 'Luna Soft',
    'control_brand_subtitle' => 'Human Resource Management',
    'control_nav_heading' => 'Overview',
    'control_nav_home' => 'Home',
    'control_nav_management' => 'Profile Management',
    'control_nav_admin' => 'Administrators',
    'control_nav_hr' => 'HR & Staffing',
    'control_nav_declaration' => 'Declaration',
    'control_nav_operations' => 'Operations',
    'control_nav_outgoing' => 'Outgoing',
    'control_nav_incoming' => 'Incoming',
    'control_nav_outgoing_documents' => 'OUTGOING DOCUMENTS',
    'control_nav_incoming_documents' => 'INCOMING DOCUMENTS',
    'control_nav_search_records' => 'Search Records',
    'control_nav_notifications' => 'Notifications',
    'control_nav_manage_employees' => 'Manage Employees',
    'control_nav_employee_list' => 'Employee List',
    'control_nav_manage_forms' => 'Forms - Templates',
    'control_nav_monthly_report' => 'Monthly Report',
    'control_nav_hr_processing' => 'HR Processing',
    'control_nav_mcc_processing' => 'Timekeeping Machine',
    'control_nav_attendance_data' => 'Attendance Data',
    'control_nav_planner' => 'Work Planning',
    'control_nav_reports' => 'Reports',
    'control_nav_ui' => 'UI Elements',
    'control_nav_tables' => 'Tables',
    'control_nav_data' => 'Data Presentation',
    'control_nav_layouts' => 'Layouts',
    'control_footer_heading' => 'Live on',
    'control_footer_pages' => 'Additional Pages',
    'control_footer_extras' => 'Extras',
    'control_footer_multilevel' => 'Multilevel Menu',
    'control_footer_copyright' => 'Copyright © Luna Software 2024-2025',
    'control_header_toggle_collapse' => 'Collapse menu',
    'control_header_toggle_expand' => 'Expand menu',
    'control_header_role' => 'Administrator',
    'control_header_logout' => 'Logout',
    'control_header_profile' => 'Personal Profile',
    'control_header_change_password' => 'Change Password',
    'control_header_notifications' => 'Notifications',
    'control_header_user_menu' => 'User Menu',
    'control_nav_company' => 'Company',
    'control_nav_category' => 'Category',
    'control_nav_zalo' => 'Zalo',
    'control_nav_admin_declaration' => 'Declaration',
    
    // Zalo page
    'zalo_heading_list' => 'ZALO BOT CONFIGS',
    'zalo_btn_add_new' => 'Add New',
    'zalo_col_id' => 'ID',
    'zalo_col_name' => 'Name',
    'zalo_col_user_number' => 'User Count',
    'zalo_col_message' => 'Message',
    'zalo_col_token' => 'Token',
    'zalo_col_link_qr' => 'QR Link',
    'zalo_col_actions' => 'Actions',
    'zalo_empty' => 'No Zalo configs yet',
    'zalo_form_heading' => 'ADD / UPDATE ZALO',
    'zalo_form_name_label' => 'Bot Name <span class="required-asterisk">*</span>',
    'zalo_form_name_placeholder' => 'Enter Bot Zalo name',
    'zalo_form_user_number_label' => 'User Count',
    'zalo_form_user_number_placeholder' => 'Enter user count',
    'zalo_form_message_number_label' => 'Message Count',
    'zalo_form_message_number_placeholder' => 'Enter message count',
    'zalo_form_token_label' => 'Token <span class="required-asterisk">*</span>',
    'zalo_form_token_placeholder' => 'Enter Zalo token',
    'zalo_form_link_qr_label' => 'QR Update <span class="required-asterisk">*</span>',
    'zalo_form_link_qr_placeholder' => 'Enter QR code link',
    'zalo_btn_save' => 'Save',
    'zalo_btn_update' => 'Update',
    'zalo_btn_reset' => 'Reset',
    'zalo_tooltip_edit' => 'Edit',
    'zalo_tooltip_delete' => 'Delete',
    'zalo_confirm_delete' => 'Are you sure you want to delete this Zalo Bot?',
    'zalo_error_name_required' => 'Bot Name is required',
    'zalo_error_token_required' => 'Token is required',
    'zalo_error_qr_required' => 'Please upload QR Code',
    'zalo_error_linkQR_required' => 'QR has not been updated for BOT',
    'zalo_error_qr_file_not_found' => 'QR image file does not exist',
    'zalo_error_token_duplicate' => 'This token already exists in the system',
    'zalo_success_created' => 'Zalo Bot created successfully!',
    'zalo_success_updated' => 'Zalo Bot updated successfully!',
    'zalo_success_deleted' => 'Zalo Bot deleted successfully!',
    
    // Company page
    'company_heading_list' => 'EXISTING COMPANY',
    'company_col_id' => 'ID',
    'company_col_name_vn' => 'Name (VN)',
    'company_col_name_eng' => 'Name (ENG)',
    'company_col_actions' => 'Actions',
    'company_action_delete' => 'Delete',
    'company_action_edit' => 'Edit',
    'company_form_heading' => 'ADD/UPDATE COMPANY',
    'company_create_heading' => 'ADD COMPANY',
    'company_update_heading' => 'UPDATE COMPANY',
    'company_form_name_vn_label' => 'Name (VN)',
    'company_form_name_vn_placeholder' => 'E.g., Joint Stock Company ...',
    'company_form_name_eng_label' => 'Name (ENG)',
    'company_form_name_eng_placeholder' => 'E.g., QNS',
    'company_btn_save' => 'Save',
    'company_btn_update' => 'Update',
    'company_btn_reset' => 'Reset',
    'company_empty' => 'No data yet',
    'company_confirm_delete' => 'Delete this item?',
    'company_create_success' => 'Company added.',
    'company_update_success' => 'Company updated.',
    'company_delete_success' => 'Company deleted.',
    'company_create_failed' => 'Create failed.',
    'company_update_failed' => 'Update failed.',
    'company_delete_failed' => 'Delete failed.',
    'company_require_name' => 'Please enter at least one of the names.',
    'company_require_both' => 'Please enter both Vietnamese and English names.',
    'company_duplicate_name_vn' => 'Vietnamese name already exists.',
    'company_duplicate_name_eng' => 'English name already exists.',
    'company_connection_failed' => 'Cannot connect to the database.',
    'company_list_failed' => 'Unable to load company list.',
    'company_btn_add_new' => 'Add new',
    
    // Category page
    'category_heading_list' => 'EXISTING CATEGORIES',
    'category_col_id' => 'ID',
    'category_col_name_vn' => 'Name (VN)',
    'category_col_name_eng' => 'Name (ENG)',
    'category_col_actions' => 'Actions',
    'category_action_delete' => 'Delete',
    'category_action_edit' => 'Edit',
    'category_form_heading' => 'ADD/UPDATE CATEGORY',
    'category_create_heading' => 'ADD CATEGORY',
    'category_update_heading' => 'UPDATE CATEGORY',
    'category_form_name_vn_label' => 'Name (VN)',
    'category_form_name_vn_placeholder' => 'E.g., Category A ...',
    'category_form_name_eng_label' => 'Name (ENG)',
    'category_form_name_eng_placeholder' => 'E.g., Category A',
    'category_btn_save' => 'Save',
    'category_btn_update' => 'Update',
    'category_btn_reset' => 'Reset',
    'category_empty' => 'No data yet',
    'category_confirm_delete' => 'Delete this item?',
    'category_create_success' => 'Category added.',
    'category_update_success' => 'Category updated.',
    'category_delete_success' => 'Category deleted.',
    'category_create_failed' => 'Create failed.',
    'category_update_failed' => 'Update failed.',
    'category_delete_failed' => 'Delete failed.',
    'category_require_name' => 'Please enter both Vietnamese and English names.',
    'category_duplicate_name_vn' => 'Vietnamese name already exists.',
    'category_duplicate_name_eng' => 'English name already exists.',
    'category_connection_failed' => 'Cannot connect to the database.',
    'category_list_failed' => 'Unable to load category list.',
    
    // Incoming Documents page
    'incoming_heading_list' => 'EXISTING INCOMING DOCUMENTS',
    'incoming_col_id' => 'ID',
    'incoming_col_symbol' => 'Symbol',
    'incoming_col_title' => 'Title',
    'incoming_col_company' => 'Company',
    'incoming_col_category' => 'Category',
    'incoming_col_effective_date' => 'Effective Date',
    'incoming_col_issuer' => 'Issuing Authority',
    'incoming_col_actions' => 'Actions',
    'incoming_action_delete' => 'Delete',
    'incoming_action_edit' => 'Edit',
    'incoming_form_heading' => 'ADD/UPDATE INCOMING DOCUMENT',
    'incoming_create_heading' => 'ADD INCOMING DOCUMENT',
    'incoming_update_heading' => 'UPDATE INCOMING DOCUMENT',
    'incoming_form_symbol_label' => 'Symbol',
    'incoming_form_symbol_placeholder' => 'E.g., 123/QĐ-UBND',
    'incoming_form_document_code_label' => 'Document Code',
    'incoming_form_document_code_placeholder' => 'Enter document code',
    'incoming_form_title_label' => 'Title <span class="required-asterisk">*</span>',
    'incoming_form_title_placeholder' => 'Enter document title',
    'incoming_form_summary_label' => 'Content Summary',
    'incoming_form_summary_placeholder' => 'Enter content summary',
    'incoming_form_type_label' => 'Type <span class="required-asterisk">*</span>',
    'incoming_form_type_placeholder' => 'Enter document type',
    'incoming_form_type_doc_label' => 'Document Type <span class="required-asterisk">*</span>',
    'incoming_form_type_doc_placeholder' => 'Enter document type',
    'incoming_form_quantity_label' => 'Quantity <span class="required-asterisk">*</span>',
    'incoming_form_quantity_placeholder' => 'Enter quantity',
    'incoming_form_issuer_label' => 'Issuing Authority <span class="required-asterisk">*</span>',
    'incoming_form_issuer_placeholder' => 'Enter issuing authority',
    'incoming_form_effective_label' => 'Effective Date <span class="required-asterisk">*</span>',
    'incoming_form_effective_placeholder' => 'dd/mm/yyyy',
    'incoming_form_expiry_label' => 'Expiry Date',
    'incoming_form_expiry_placeholder' => 'dd/mm/yyyy',
    'incoming_form_company_label' => 'Belongs to Company <span class="required-asterisk">*</span>',
    'incoming_form_company_placeholder' => 'Select company',
    'incoming_form_category_label' => 'Category <span class="required-asterisk">*</span>',
    'incoming_form_category_placeholder' => 'Select category',
    'incoming_form_item_label' => 'Item',
    'incoming_form_item_placeholder' => 'Enter item',
    'incoming_form_file_link_label' => 'File Link',
    'incoming_form_file_link_placeholder' => 'Enter file link',
    'incoming_form_notes_label' => 'Notes',
    'incoming_form_notes_placeholder' => 'Enter notes',
    'incoming_form_upload_pdf' => 'Upload PDF',
    'pdf_tooltip_download' => 'Download',
    'pdf_tooltip_rotate' => 'Rotate',
    'pdf_tooltip_print' => 'Print',
    'pdf_tooltip_close' => 'Close',
    'pdf_tooltip_prev' => 'Previous page',
    'pdf_tooltip_next' => 'Next page',
    'pdf_tooltip_zoom_in' => 'Zoom in',
    'pdf_tooltip_zoom_out' => 'Zoom out',
    'incoming_form_file_storage_label' => 'File Storage Location',
    'incoming_form_file_storage_placeholder' => 'Enter file storage location',
    'incoming_form_employee_id_label' => 'Employee ID',
    'incoming_form_employee_id_placeholder' => 'Enter employee ID',
    'incoming_form_created_at_label' => 'Entry Date',
    'incoming_form_created_at_placeholder' => 'Enter entry date',
    'incoming_btn_save' => 'Save',
    'incoming_btn_update' => 'Update',
    'incoming_btn_cancel' => 'Cancel',
    'incoming_tooltip_edit' => 'Edit',
    'incoming_tooltip_view' => 'View file',
    'incoming_tooltip_delete' => 'Delete',
    'incoming_tooltip_view_pdf' => 'View PDF file',
    'incoming_tooltip_export' => 'Export file',
    'incoming_btn_reset' => 'Reset',
    'company_tooltip_edit' => 'Edit',
    'company_tooltip_delete' => 'Delete',
    'category_tooltip_edit' => 'Edit',
    'category_tooltip_delete' => 'Delete',
    'table_info_display' => 'Displaying',
    'table_info_of_total' => 'out of',
    'table_info_company' => 'companies',
    'table_info_category' => 'categories',
    'table_info_document' => 'documents',
    'pagination_previous' => 'Previous',
    'pagination_next' => 'Next',
    'incoming_empty' => 'No data yet',
    'incoming_confirm_delete' => 'Delete this item?',
    'incoming_create_success' => 'Incoming document added.',
    'incoming_update_success' => 'Incoming document updated.',
    'incoming_delete_success' => 'Incoming document deleted.',
    'incoming_create_failed' => 'Create failed.',
    'incoming_update_failed' => 'Update failed.',
    'incoming_update_db_error' => 'Database update error.',
    'incoming_delete_failed' => 'Delete failed.',
    'incoming_error_delete_failed' => 'Unable to delete document',
    'incoming_error_file_not_found' => 'File not found',
    'incoming_error_db_connection' => 'Unable to connect to database',
    'incoming_error_db_query' => 'Database query error',
    'incoming_error_not_found' => 'Document not found',
    'incoming_get_file_success' => 'Success',
    'incoming_invalid_id' => 'Invalid document ID.',
    'incoming_require_title' => 'Title is required.',
    'incoming_require_effective_date' => 'Effective date is required.',
    'incoming_require_summary' => 'Summary is required.',
    'incoming_require_type' => 'Type is required.',
    'incoming_require_document_type' => 'Document type is required.',
    'incoming_require_quantity' => 'Quantity is required.',
    'incoming_require_issuer' => 'Issuing authority is required.',
    'incoming_require_company' => 'Company is required.',
    'incoming_require_category' => 'Category is required.',
    'incoming_require_employee_id' => 'Employee ID is required.',
    'incoming_require_symbol' => 'Symbol is required.',
    'incoming_require_data' => 'Required data is missing',
    'incoming_connection_failed' => 'Cannot connect to the database.',
    'incoming_list_failed' => 'Unable to load incoming documents list.',
    'incoming_btn_add_new' => 'Add new',
    // Shared messages
    'incoming_max_size' => 'File size too large. Maximum 50MB allowed',
    'outgoing_col_receiver' => 'Receiving Authority',
    
    // Export Modal
    'export_modal_title' => 'EXPORT FILE',
    'export_quantity_label' => 'Quantity <span class="required-asterisk">*</span>',
    'export_quantity_placeholder' => 'Enter export quantity',
    'export_quantity_max_label' => 'Max',
    'export_recipient_label' => 'Recipient <span class="required-asterisk">*</span>',
    'export_recipient_placeholder' => 'Select recipient',
    'export_reason_label' => 'Export Reason <span class="required-asterisk">*</span>',
    'export_reason_placeholder' => 'Enter export reason',
    'export_btn_save' => 'Export file',
    'export_validation_missing_data' => 'Please fill in all required information',
    'export_validation_exceed_quantity' => 'Export quantity cannot exceed available quantity',
    'export_validation_positive_quantity' => 'Export quantity must be greater than 0',
    'export_processing_message' => 'Processing file export...',
    'export_success_message' => 'Export recorded',
    'export_success_suffix' => 'files. Reason:',
    'export_error_invalid_id' => 'Invalid document ID',
    'export_error_invalid_quantity' => 'Export quantity must be greater than 0',
    'export_error_no_recipient' => 'Please select a recipient',
    'export_error_no_reason' => 'Please enter export reason',
    'export_error_db_connection' => 'Unable to connect to database',
    'export_error_db_query' => 'Database query error',
    'export_error_not_found' => 'Document not found',
    'export_error_exceed_quantity' => 'Export quantity exceeds available quantity',
    'export_error_update_failed' => 'Unable to update document quantity',
    'export_success' => 'File exported successfully. Exported {quantity} file(s) to {recipient}',
    
    // Outgoing Documents page
    'outgoing_create_heading' => 'ADD OUTGOING DOCUMENT',
    'outgoing_update_heading' => 'UPDATE OUTGOING DOCUMENT',
    'outgoing_form_receiver_label' => 'Receiving Authority <span class="required-asterisk">*</span>',
    'outgoing_form_receiver_placeholder' => 'Enter receiving authority',
    'outgoing_create_success' => 'Outgoing document added successfully.',
    'outgoing_create_failed' => 'Create failed.',
    'outgoing_update_success' => 'Outgoing document updated successfully.',
    'outgoing_update_failed' => 'Update failed.',
    'outgoing_require_receiver' => 'Missing Receiving Authority.',
    
    // Search functionality
    'search_placeholder' => 'Search by symbol, title, issuing authority...',
    'search_button' => 'Search',
    'search_clear' => 'Clear search',
    'search_results_found' => 'Found',
    'search_results_for' => 'results for',
    
    // Error page messages
    'error_invalid_access' => 'Invalid access.',
    'error_use_interface' => 'Please use the system interface.',
    'error_back_to_company' => 'Back to Company page',
    'error_unauthorized' => 'Unauthorized request.',
    'error_invalid_action' => 'Invalid action',
    'system_error' => 'System error',
    'error_notification_title' => 'NOTIFICATION',
    'success_notification_title' => 'NOTIFICATION',
    
    // Zalo page
    'zalo_page_title' => 'Zalo Bot Management',
    'zalo_total_users' => 'Total Users',
    'zalo_total_bots' => 'Total Bots',
    'zalo_total_messages' => 'Total Messages',
    'zalo_system_info' => 'Zalo Bot System Information',
    'zalo_no_bots' => 'No Zalo Bots yet',
    'zalo_no_bots_desc' => 'Click "Add New" button to create your first bot',
    'zalo_bot_id' => 'BOT',
    'zalo_user_count' => 'User Count',
    'zalo_message_count' => 'Message Count',
    'zalo_user_label' => 'User',
    'zalo_message_label' => 'Msg',
    'zalo_total_user_label' => 'Total Users',
    'zalo_total_message_label' => 'Total Msg',
    'zalo_token_label' => 'Token',
    'zalo_qr_code_label' => 'QR Code',
    'zalo_dashboard_btn' => 'Dashboard',
    'zalo_integration_btn' => 'Integration Docs',
    'zalo_guide_btn' => 'Guide',
    'zalo_source_code_btn' => 'Source Code',
    'zalo_qr_modal_title' => 'QR Code Information',
    'zalo_receive_messages_btn' => 'Get ID',
    
    // Zalo Messages Modal
    'zalo_messages_modal_title' => 'Receive Messages',
    'zalo_messages_start_listening' => 'Start Listening',
    'zalo_messages_stop_listening' => 'Stop Listening',
    'zalo_messages_status_listening' => 'Listening...',
    'zalo_messages_status_not_started' => 'Not Started',
    'zalo_messages_status_stopped' => 'Stopped',
    'zalo_messages_show_json' => 'View JSON',
    'zalo_messages_clear_log' => 'Clear Log',
    'zalo_messages_copy_id' => 'Copy ID',
    'zalo_messages_copied' => 'Copied!',
    'zalo_messages_copy_failed' => 'Failed',
    'zalo_messages_empty_state' => 'Click "Start Listening" to receive messages from Zalo Bot',
    'zalo_messages_bot_label' => 'Bot:',
    'zalo_view_logs' => 'View Logs',
    
    // Common buttons
    'btn_edit' => 'Edit',
    'btn_delete' => 'Delete',
    'back_to_list' => 'Back',
    
    // Log pages
    'log_page_title_zalo' => 'ZALO MESSAGE LOG',
    'log_page_title_incoming' => 'INCOMING MESSAGE LOG',
    'log_total_logs' => 'Total Logs',
    'log_info' => 'Info',
    'log_success' => 'Success',
    'log_error' => 'Error',
    'log_debug' => 'Debug',
    'log_update' => 'Update',
    'log_export' => 'Export',
    'log_import' => 'Import',
    'log_display_label' => 'Display:',
    'log_level_label' => 'Level:',
    'log_filter_value_label' => 'Filter Value:',
    'log_refresh_button' => 'Refresh',
    'log_all_levels' => 'All',
    'log_lines_50' => '50 last lines',
    'log_lines_100' => '100 last lines',
    'log_lines_200' => '200 last lines',
    'log_lines_500' => '500 last lines',
    'log_lines_1000' => '1000 last lines',
    'log_no_logs_found' => 'No logs found',
    'log_file_not_exists' => 'Log file does not exist. Send first Zalo message to create log.',
    'log_file_not_exists_incoming' => 'Log file does not exist. Receive first message to create log.',
    'log_file_size' => 'Size:',
    'log_file_last_modified' => 'Last modified:',
    'log_file_path' => 'Log file:',
    'log_filter_placeholder' => 'Enter value...',
    'log_filter_id_placeholder' => 'Enter document ID...',
    
    // Excel Export Modal
    'excel_export_btn' => 'Export Excel',
    'excel_export_modal_title' => 'EXPORT EXCEL - INCOMING DOCUMENTS',
    'excel_export_modal_subtitle' => 'Select export conditions:',
    'excel_export_all_documents' => 'Export all documents',
    'excel_export_by_company' => 'By company',
    'excel_export_by_document_number' => 'By document number',
    'excel_export_by_effective_date' => 'By effective date',
    'excel_export_select_company' => 'Select company',
    'excel_export_document_number_placeholder' => 'Enter document number',
    'excel_export_date_from_placeholder' => 'From date',
    'excel_export_date_to_placeholder' => 'To date',
    'excel_export_btn_export' => 'Export Excel',
    'excel_export_btn_close' => 'Close',
    
    // Excel Export Validation Messages
    'excel_export_validation_company_required' => 'Please select a company',
    'excel_export_validation_document_number_required' => 'Please enter document number',
    'excel_export_validation_date_range_required' => 'Please select date range',
    'excel_export_validation_date_from_after_to' => 'Start date must be before end date',
    
    // Excel Export Success/Error Messages
    'excel_export_success' => 'Excel export successful',
    'excel_export_error_no_data' => 'No data to export',
    'excel_export_error_company_not_found' => 'Company not found',
    'excel_export_error_document_not_found' => 'Document not found',
    'excel_export_error_invalid_date_range' => 'Invalid date range',
    'excel_export_error_database_connection' => 'Database connection error',
    'excel_export_error_file_generation' => 'Excel file generation error',
    'excel_export_error_permission' => 'No permission to export file',
    
    // Excel Headers
    'excel_sheet_title' => 'Incoming Documents',
    'excel_header_stt' => 'No.',
    'excel_header_doc_number' => 'Document Number',
    'excel_header_title' => 'Title',
    'excel_header_company' => 'Company',
    'excel_header_category' => 'Category',
    'excel_header_doc_type' => 'Document Type',
    'excel_header_page_type' => 'Page Type',
    'excel_header_effective_date' => 'Effective Date',
    'excel_header_quantity' => 'Quantity',
    'excel_header_storage' => 'Storage Location',
    'excel_header_exporter' => 'Exporter',
    'excel_header_notes' => 'Notes',
    'excel_header_created_at' => 'Created Date',

    // Personal Profile Page
    'profile_page_title' => 'PERSONAL PROFILE',
    'profile_avatar_alt' => 'Avatar',
    'profile_label_fullname' => 'Full Name',
    'profile_label_employee_code' => 'Employee Code',
    'profile_label_birthdate' => 'Date of Birth',
    'profile_label_gender' => 'Gender',
    'profile_label_cccd' => 'ID Card Number',
    'profile_label_cccd_issue_date' => 'ID Card Issue Date',
    'profile_label_cmnd' => 'Old ID Number',
    'profile_label_marital_status' => 'Marital Status',
    'profile_label_address' => 'Permanent Address',
    'profile_label_new_address' => 'New Permanent Address',
    'profile_label_address_ward' => 'Ward/Commune',
    'profile_label_address_district' => 'District',
    'profile_label_address_province' => 'Province/City',
    'profile_label_new_address_ward' => 'Ward/Commune (new)',
    'profile_label_new_address_province' => 'Province/City (new)',
    'profile_label_email' => 'Email Address',
    'profile_label_phone' => 'Contact Phone',
    'profile_label_bhxh' => 'Social Insurance No.',
    'profile_btn_edit' => 'Edit Profile',
    'profile_edit_modal_title' => 'EDIT PROFILE',
    'profile_edit_save' => 'Save changes',
    'profile_edit_cancel' => 'Cancel',
    'profile_edit_success' => 'Profile updated successfully.',
    'profile_edit_error' => 'Unable to update your profile.',
    'profile_edit_invalid_method' => 'Invalid request method.',
    'profile_edit_unauthorized' => 'You must be logged in to continue.',
    'profile_edit_no_changes' => 'No data to update.',
    'profile_avatar_update_success' => 'Avatar updated successfully.',
    'profile_avatar_update_error' => 'Unable to update avatar. Please try again.',
    'profile_avatar_invalid_file' => 'Invalid image format.',
];

