-- Tạo index để tối ưu hiệu suất truy vấn cho bảng Document (Công văn đến) và GoDocument (Công văn đi)
-- Chạy script này để cải thiện tốc độ load dữ liệu Công văn đến và Công văn đi

-- ============================================
-- INDEXES CHO BẢNG Document (Công văn đến)
-- ============================================

-- Index cho EffectiveDate (dùng trong ORDER BY)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Document_EffectiveDate' AND object_id = OBJECT_ID('Document'))
BEGIN
    CREATE INDEX IX_Document_EffectiveDate ON Document(EffectiveDate DESC);
    PRINT 'Đã tạo index IX_Document_EffectiveDate';
END
ELSE
BEGIN
    PRINT 'Index IX_Document_EffectiveDate đã tồn tại';
END
GO

-- Composite index cho ORDER BY EffectiveDate DESC, Id DESC
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Document_EffectiveDate_Id' AND object_id = OBJECT_ID('Document'))
BEGIN
    CREATE INDEX IX_Document_EffectiveDate_Id ON Document(EffectiveDate DESC, Id DESC);
    PRINT 'Đã tạo index IX_Document_EffectiveDate_Id';
END
ELSE
BEGIN
    PRINT 'Index IX_Document_EffectiveDate_Id đã tồn tại';
END
GO

-- Index cho ID_Symbol (dùng trong search)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Document_ID_Symbol' AND object_id = OBJECT_ID('Document'))
BEGIN
    CREATE INDEX IX_Document_ID_Symbol ON Document(ID_Symbol);
    PRINT 'Đã tạo index IX_Document_ID_Symbol';
END
ELSE
BEGIN
    PRINT 'Index IX_Document_ID_Symbol đã tồn tại';
END
GO

-- Index cho TitleVi (dùng trong search)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Document_TitleVi' AND object_id = OBJECT_ID('Document'))
BEGIN
    CREATE INDEX IX_Document_TitleVi ON Document(TitleVi);
    PRINT 'Đã tạo index IX_Document_TitleVi';
END
ELSE
BEGIN
    PRINT 'Index IX_Document_TitleVi đã tồn tại';
END
GO

-- Index cho Issuer (dùng trong search)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Document_Issuer' AND object_id = OBJECT_ID('Document'))
BEGIN
    CREATE INDEX IX_Document_Issuer ON Document(Issuer);
    PRINT 'Đã tạo index IX_Document_Issuer';
END
ELSE
BEGIN
    PRINT 'Index IX_Document_Issuer đã tồn tại';
END
GO

-- Index cho ID_Company (dùng trong JOIN)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Document_ID_Company' AND object_id = OBJECT_ID('Document'))
BEGIN
    CREATE INDEX IX_Document_ID_Company ON Document(ID_Company);
    PRINT 'Đã tạo index IX_Document_ID_Company';
END
ELSE
BEGIN
    PRINT 'Index IX_Document_ID_Company đã tồn tại';
END
GO

-- Index cho ID_Category (dùng trong JOIN)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Document_ID_Category' AND object_id = OBJECT_ID('Document'))
BEGIN
    CREATE INDEX IX_Document_ID_Category ON Document(ID_Category);
    PRINT 'Đã tạo index IX_Document_ID_Category';
END
ELSE
BEGIN
    PRINT 'Index IX_Document_ID_Category đã tồn tại';
END
GO

-- ============================================
-- INDEXES CHO BẢNG GoDocument (Công văn đi)
-- ============================================

-- Index cho EffectiveDate (dùng trong ORDER BY)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_GoDocument_EffectiveDate' AND object_id = OBJECT_ID('GoDocument'))
BEGIN
    CREATE INDEX IX_GoDocument_EffectiveDate ON GoDocument(EffectiveDate DESC);
    PRINT 'Đã tạo index IX_GoDocument_EffectiveDate';
END
ELSE
BEGIN
    PRINT 'Index IX_GoDocument_EffectiveDate đã tồn tại';
END
GO

-- Composite index cho ORDER BY EffectiveDate DESC, Id DESC
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_GoDocument_EffectiveDate_Id' AND object_id = OBJECT_ID('GoDocument'))
BEGIN
    CREATE INDEX IX_GoDocument_EffectiveDate_Id ON GoDocument(EffectiveDate DESC, Id DESC);
    PRINT 'Đã tạo index IX_GoDocument_EffectiveDate_Id';
END
ELSE
BEGIN
    PRINT 'Index IX_GoDocument_EffectiveDate_Id đã tồn tại';
END
GO

-- Index cho ID_Symbol (dùng trong search)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_GoDocument_ID_Symbol' AND object_id = OBJECT_ID('GoDocument'))
BEGIN
    CREATE INDEX IX_GoDocument_ID_Symbol ON GoDocument(ID_Symbol);
    PRINT 'Đã tạo index IX_GoDocument_ID_Symbol';
END
ELSE
BEGIN
    PRINT 'Index IX_GoDocument_ID_Symbol đã tồn tại';
END
GO

-- Index cho TitleVi (dùng trong search)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_GoDocument_TitleVi' AND object_id = OBJECT_ID('GoDocument'))
BEGIN
    CREATE INDEX IX_GoDocument_TitleVi ON GoDocument(TitleVi);
    PRINT 'Đã tạo index IX_GoDocument_TitleVi';
END
ELSE
BEGIN
    PRINT 'Index IX_GoDocument_TitleVi đã tồn tại';
END
GO

-- Index cho Issuer (dùng trong search)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_GoDocument_Issuer' AND object_id = OBJECT_ID('GoDocument'))
BEGIN
    CREATE INDEX IX_GoDocument_Issuer ON GoDocument(Issuer);
    PRINT 'Đã tạo index IX_GoDocument_Issuer';
END
ELSE
BEGIN
    PRINT 'Index IX_GoDocument_Issuer đã tồn tại';
END
GO

-- Index cho ID_Company (dùng trong JOIN)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_GoDocument_ID_Company' AND object_id = OBJECT_ID('GoDocument'))
BEGIN
    CREATE INDEX IX_GoDocument_ID_Company ON GoDocument(ID_Company);
    PRINT 'Đã tạo index IX_GoDocument_ID_Company';
END
ELSE
BEGIN
    PRINT 'Index IX_GoDocument_ID_Company đã tồn tại';
END
GO

-- ============================================
-- INDEXES CHO BẢNG Company (dùng trong JOIN)
-- ============================================

-- Index cho ID_Company (Primary key thường đã có index, nhưng đảm bảo)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Company_ID_Company' AND object_id = OBJECT_ID('Company'))
BEGIN
    CREATE INDEX IX_Company_ID_Company ON Company(ID_Company);
    PRINT 'Đã tạo index IX_Company_ID_Company';
END
ELSE
BEGIN
    PRINT 'Index IX_Company_ID_Company đã tồn tại';
END
GO

-- ============================================
-- INDEXES CHO BẢNG Category (dùng trong JOIN)
-- ============================================

-- Index cho ID_Category (Primary key thường đã có index, nhưng đảm bảo)
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = 'IX_Category_ID_Category' AND object_id = OBJECT_ID('Category'))
BEGIN
    CREATE INDEX IX_Category_ID_Category ON Category(ID_Category);
    PRINT 'Đã tạo index IX_Category_ID_Category';
END
ELSE
BEGIN
    PRINT 'Index IX_Category_ID_Category đã tồn tại';
END
GO

PRINT 'Hoàn thành tạo index cho bảng Document và GoDocument';



