# Giải thích và xử lý Warning về Maximum Key Length

## Vấn đề

Khi chạy script `create_document_indexes.sql`, bạn có thể gặp warning:

```
Warning! The maximum key length is 900 bytes. The index '[index_name]' has maximum length of 1000 bytes. 
For some combination of large values, the insert/update operation will fail.
```

**Các index bị ảnh hưởng:**
- `IX_Document_ID_Symbol`
- `IX_Document_TitleVi`
- `IX_GoDocument_ID_Symbol`
- `IX_GoDocument_TitleVi`

## Nguyên nhân

- SQL Server có giới hạn **900 bytes** cho index key length
- Các cột `ID_Symbol` và `TitleVi` có thể là `NVARCHAR(500)` hoặc lớn hơn
- Với `NVARCHAR`, mỗi ký tự = 2 bytes → 500 ký tự = 1000 bytes (vượt quá 900 bytes)

## Mức độ nghiêm trọng

### ⚠️ Có ảnh hưởng nhưng không nghiêm trọng ngay:

1. **Index vẫn được tạo thành công** - Warning không ngăn việc tạo index
2. **Index vẫn hoạt động** - Chỉ ảnh hưởng khi insert/update giá trị quá dài
3. **Rủi ro thực tế thấp** - Nếu dữ liệu hiện tại không có giá trị > 450 ký tự, không sao

### ⚠️ Rủi ro tiềm ẩn:

- Nếu có record với `ID_Symbol` hoặc `TitleVi` > 450 ký tự, khi insert/update sẽ **FAIL**
- SQL Server sẽ từ chối insert/update với error: "The index entry of length X bytes for the index 'IX_...' exceeds the maximum length of 900 bytes"

## Giải pháp

### Option 1: Sử dụng Filtered Index (Khuyến nghị) ✅

Đã tạo file `create_document_indexes_fixed.sql` với filtered index:

```sql
CREATE INDEX IX_Document_ID_Symbol ON Document(ID_Symbol) 
WHERE LEN(ID_Symbol) <= 450;
```

**Ưu điểm:**
- Không có warning
- Index vẫn hoạt động tốt cho 99% trường hợp (giá trị <= 450 ký tự)
- An toàn, không gây lỗi insert/update

**Nhược điểm:**
- Các giá trị > 450 ký tự sẽ không được index (nhưng vẫn có thể search được, chỉ chậm hơn)

### Option 2: Giữ nguyên (Nếu dữ liệu hiện tại OK)

Nếu bạn chắc chắn rằng:
- Không có `ID_Symbol` hoặc `TitleVi` nào > 450 ký tự
- Và sẽ không có trong tương lai

→ Có thể **giữ nguyên** index hiện tại, warning không ảnh hưởng.

### Option 3: Xóa và tạo lại với Filtered Index

Nếu muốn xóa warning:

```sql
-- Xóa index cũ
DROP INDEX IX_Document_ID_Symbol ON Document;
DROP INDEX IX_Document_TitleVi ON Document;
DROP INDEX IX_GoDocument_ID_Symbol ON GoDocument;
DROP INDEX IX_GoDocument_TitleVi ON GoDocument;

-- Sau đó chạy script create_document_indexes_fixed.sql
```

## Khuyến nghị

1. **Kiểm tra dữ liệu hiện tại:**
   ```sql
   SELECT MAX(LEN(ID_Symbol)) as MaxSymbolLength FROM Document;
   SELECT MAX(LEN(TitleVi)) as MaxTitleLength FROM Document;
   SELECT MAX(LEN(ID_Symbol)) as MaxSymbolLength FROM GoDocument;
   SELECT MAX(LEN(TitleVi)) as MaxTitleLength FROM GoDocument;
   ```

2. **Nếu tất cả <= 450 ký tự:**
   - Có thể giữ nguyên (warning không ảnh hưởng)
   - Hoặc chạy script `create_document_indexes_fixed.sql` để xóa warning

3. **Nếu có giá trị > 450 ký tự:**
   - **Bắt buộc** phải dùng filtered index
   - Hoặc rút ngắn dữ liệu trước khi tạo index

## Kết luận

**Warning này KHÔNG nghiêm trọng nếu:**
- Dữ liệu hiện tại không có giá trị > 450 ký tự
- Bạn không có kế hoạch insert giá trị dài

**Nên xử lý nếu:**
- Muốn tránh rủi ro trong tương lai
- Muốn code "sạch" không có warning
- Có thể có dữ liệu dài trong tương lai

→ **Khuyến nghị:** Chạy script `create_document_indexes_fixed.sql` để an toàn và không có warning.



